% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/init.R
\name{cnlp_init_udpipe}
\alias{cnlp_init_udpipe}
\title{Interface for initializing the udpipe backend}
\usage{
cnlp_init_udpipe(
  model_name = NULL,
  model_path = NULL,
  tokenizer = "tokenizer",
  tagger = "default",
  parser = "default"
)
}
\arguments{
\item{model_name}{string giving the model namel.
Defaults to "english" if NULL.
Ignored if \code{model_path} is not NULL.}

\item{model_path}{provide a full path to a model file.}

\item{tokenizer}{a character string of length 1, which is either
'tokenizer' (default udpipe tokenisation) or a
character string with more
complex tokenisation options as specified in <URL:
http://ufal.mff.cuni.cz/udpipe/users-manual> in which
case tokenizer should be a character string where the
options are put after each other using the semicolon as
separation.}

\item{tagger}{a character string of length 1, which is either 'default'
(default udpipe POS tagging and lemmatisation) or 'none' (no
POS tagging and lemmatisation needed) or a character string
with more complex tagging options as specified in <URL:
http://ufal.mff.cuni.cz/udpipe/users-manual> in which case
tagger should be a character string where the options are
put after each other using the semicolon as separation.}

\item{parser}{a character string of length 1, which is either 'default'
(default udpipe dependency parsing) or 'none' (no dependency
parsing needed) or a character string with more complex
parsing options as specified in <URL:
http://ufal.mff.cuni.cz/udpipe/users-manual> in which case
parser should be a character string where the options are
put after each other using the semicolon as separation.}
}
\description{
This function must be run before annotating text with
the udpipe backend. It will parse in English by default,
but you can load other models as well.
}
\examples{
\dontrun{
cnlp_init_udpipe(model_name = "english")
}

}
\author{
Taylor B. Arnold, \email{taylor.arnold@acm.org}
}
