% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wrappers.R
\name{check_function_layout}
\alias{check_function_layout}
\title{Check a Function's Layout}
\usage{
check_function_layout(
  object,
  function_name = NULL,
  max_lines_of_code = get_cleanr_options("max_lines_of_code"),
  max_lines = get_cleanr_options("max_lines"),
  max_num_arguments = get_cleanr_options("max_num_arguments"),
  max_nesting_depth = get_cleanr_options("max_nesting_depth"),
  max_line_width = get_cleanr_options("max_line_width"),
  check_return = get_cleanr_options("check_return")
)
}
\arguments{
\item{object}{The function to be checked.}

\item{function_name}{The name to be used for reporting. Stick with the
default: If NULL, it is taken from the \code{object} given.
Argument is used internally to pass function names
retrieved via \code{\link{get}} in the wrapper function
\code{\link{check_functions_in_file}}.}

\item{max_lines_of_code}{See \code{\link{check_num_lines_of_code}}.}

\item{max_lines}{See \code{\link{check_num_lines}}.}

\item{max_num_arguments}{See \code{\link{check_num_arguments}}.}

\item{max_nesting_depth}{See \code{\link{check_nesting_depth}}.}

\item{max_line_width}{See \code{\link{check_line_width}}.}

\item{check_return}{See \code{\link{check_return}}.}
}
\value{
\code{\link[base:invisible]{Invisibly}} \code{\link{TRUE}},
but see \emph{Details}.
}
\description{
Run all \code{\link{function_checks}} on a function.
}
\details{
The functions catches the messages of "cleanr"-conditions
\code{\link{throw}}n by \code{\link{function_checks}} and, if it caught any,
\code{\link{throw}}s them.
}
\examples{
print(cleanr::check_function_layout(cleanr::check_num_lines))
}
\seealso{
Other wrappers: 
\code{\link{check_directory}()},
\code{\link{check_file_layout}()},
\code{\link{check_file}()},
\code{\link{check_functions_in_file}()},
\code{\link{check_package}()}
}
\concept{wrappers}
