% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RastProcessing.R
\name{calc.indices}
\alias{calc.indices}
\title{Calculate spectral indices}
\usage{
calc.indices(
  envrmt = .GlobalEnv$envrmt,
  vi = "all",
  bands = c("blue", "green", "red", "nir", "nirb", "re1", "re2", "re3", "swir1", "swir2"),
  overwrite = FALSE
)
}
\arguments{
\item{envrmt}{variable name of your envrmt list created using climodr's `envi.create` function. Default = envrmt.}

\item{vi}{Character. Either "all" or vector containing the preferred spectral indices. See 'Details' for more information.}

\item{bands}{Character. Vector with lenght(bands) = 10. Contains the names of the bands in the Raster Stack.
If bands from the *Usage* example vector dont exist, use "NA" in their position. See 'Details' for more information.}

\item{overwrite}{logical. Argument passed down from `terra`-package. Overwrite existing files?}
}
\value{
SpatRaster-Stack
}
\description{
Calculates a set of spectral indices to have more predictor variables available when further modeling.
}
\examples{
#create climodr environment and allow terra-functions to use 70\% of RAM
envrmt <- envi.create(proj_path = tempdir(),
                      memfrac = 0.7)

# Load the climodr example data into the current climodr environment
clim.sample(envrmt = envrmt)

# Crop all raster bands
crop.all(envrmt = envrmt,
         method = "MB_Timeseries",
         overwrite = TRUE)

# Calculate Indices from cropped raster bands
calc.indices(envrmt = envrmt,
             vi = "all",
             bands = c("blue", "green", "red",
                       "nir", "nirb",
                       "re1", "re2", "re3",
                       "swir1", "swir2"),
             overwrite = TRUE)

}
\seealso{
`crop.all`, `fin.csv`
}
