% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PreProcessing.R
\name{spat.csv}
\alias{spat.csv}
\title{Spatial aggregation for CSV-Data}
\usage{
spat.csv(
  envrmt = .GlobalEnv$envrmt,
  method = "monthly",
  des_file,
  crs = NULL,
  save_output = TRUE,
  ...
)
}
\arguments{
\item{envrmt}{variable name of your envrmt list created using climodr's `envi.create` function. Default = envrmt.}

\item{method}{character. Either "daily", monthly" or "annual". Also depends on the available data.}

\item{des_file}{character. The filename and data type of the meta-data. (Only reads .csv)}

\item{crs}{character. EPSG of the Coordinate Reference System, if no **res_area.tif** file is provided.}

\item{save_output}{logical. If cleaned data should be saved permanently in the Environment put save_output = TRUE.
Otherwise the output will be saved in the temporary directory. Default: TRUE}

\item{...}{arguments passed down from other functions.}
}
\value{
Data Frame
}
\description{
Extract station coordinates from meta-data and reproject the coordinates to the
project coordinate reference system.
}
\examples{
#create climodr environment and allow terra-functions to use 70\% of RAM
envrmt <- envi.create(proj_path = tempdir(),
                      memfrac = 0.7)

# Load the climodr example data into the current climodr environment
clim.sample(envrmt = envrmt)

#prepare csv-files
prep.csv(envrmt = envrmt,
         method = "proc",
         save_output = TRUE)

#process csv-files
csv_data <- proc.csv(envrmt = envrmt,
                     method = "monthly",
                     rbind = TRUE,
                     save_output = TRUE)

#extract station coordinates
csv_spat <- spat.csv(envrmt = envrmt,
                     method = "monthly",
                     des_file = "plot_description.csv",
                     save_output = TRUE)
head(csv_spat)

}
\seealso{
`prep.csv`, `proc.csv`, `fin.csv`
}
