\name{plot.emaxsimobj}
\alias{plot.emaxsimobj}

\title{ Plot dose response from a data set generated by emaxsim }
\description{
Plot of population dose response curve, dose group means with CIs, 
predictive intervals, and
the model-based estimated dose response curve.
}
\usage{
\method{plot}{emaxsimobj}(
    x, xlim, xat=NULL, ylim, xlab, ylab,
    plotDif=FALSE,
    plotResid=FALSE,
    clev = 0.9, 
    plotPop=c('m','3','4'),     
    negC = FALSE, 
    logScale=FALSE,
    predict=TRUE, 
    plot=TRUE, ...)
}

\arguments{
  \item{x}{Extracted data object from \code{\link{emaxsim}} }
  \item{xlim}{x-axis limits }
  \item{xat}{The points at which tick-marks are to be drawn. Errors occur if the 
  points are outside the range of xlim. By default (when NULL) tickmark locations are    computed.}
  \item{ylim}{y-axis limits }
  \item{xlab}{x-axis label }
  \item{ylab}{y-axis label }
  \item{plotDif}{When \code{TRUE}, the difference with placebo is plotted.}
  \item{plotResid}{When \code{TRUE}, residuals (dose group means) are plotted.}
  \item{clev}{Level for confidence intervals }
  \item{plotPop}{Plot population dose response curve when plotPop='m'
using linear interpolation between population means, when PlotPop='3'
or '4',
using the population Emax parameters that must be supplied with the
data generator (see \link{FixedMean} or \link{RandEmax}).  If
the Emax parameters are not available, linear interpolation is
used.}
  \item{negC}{If the ED50<lower ED50 limit, TRUE causes the Emax
model to be plotted in addition to the alternative
model selected.}
  \item{logScale}{If \code{TRUE}, log scale is used for dose.}
  \item{predict}{When \code{TRUE}, predictive intervals are plotted
  with grey errorbars in addition to the confidence intervals.}
  \item{plot}{Return plotting output without plotting.}  
  \item{\dots}{Other plot parameters (not used). }
}

\value{
ggplot object is returned
}

\author{Neal Thomas }
\seealso{\code{\link{emaxsim}}, \code{\link{print.emaxsimobj}},
\code{\link{summary.emaxsimobj}}, \code{\link{update.emaxsimobj}}}

\examples{
\dontrun{
## emaxsim changes the random number seed

nsim<-50
idmax<-5
doselev<-c(0,5,25,50,100)
n<-c(78,81,81,81,77)

### population parameters for simulation
e0<-2.465375 
ed50<-67.481113 

dtarget<-100
diftarget<-9.032497
emax<-solveEmax(diftarget,dtarget,log(ed50),1,e0)

sdy<-7.967897
pop<-c(log(ed50),emax,e0)    
meanlev<-emaxfun(doselev,pop)  

###FixedMean is specialized constructor function for emaxsim
gen.parm<-FixedMean(n,doselev,meanlev,sdy)  
D1 <- emaxsim(nsim,gen.parm)
e49<-D1[49]

plot(e49,clev=0.8)  
}
\dontshow{
## emaxsim changes the random number seed

nsim<-2
doselev<-c(0,5,25,50,100)
n<-c(78,81,81,81,77)

### population parameters for simulation
e0<-2.465375 
ed50<-67.481113 

dtarget<-100
diftarget<-9.032497
emax<-solveEmax(diftarget,dtarget,log(ed50),1,e0)

sdy<-7.967897
pop<-c(log(ed50),emax,e0)    
meanlev<-emaxfun(doselev,pop)  

###FixedMean is specialized constructor function for emaxsim
gen.parm<-FixedMean(n,doselev,meanlev,sdy)  
D1 <- emaxsim(nsim,gen.parm,nproc=1)
e2<-D1[2]

plot(e2,clev=0.8)  
}
}

\keyword{nonlinear}





