% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_dosing_weight.R
\name{calc_dosing_weight}
\alias{calc_dosing_weight}
\title{Calculate commonly used "dosing weight"}
\usage{
calc_dosing_weight(weight, height, age, sex, verbose = TRUE, ...)
}
\arguments{
\item{weight}{weight}

\item{height}{height}

\item{age}{age}

\item{sex}{sex}

\item{verbose}{verbosity (`TRUE` or `FALSE`)}

\item{...}{pased to `calc_abw()` function}
}
\value{
Returns a list of the following elements:
\item{value}{Dosing weight, in units of kg}
\item{unit}{Units of dosing weight (kg)}
\item{type}{Type of dosing weight selected, e.g., total body weight, ideal body weight.}
}
\description{
Dosing weight is determined based on total (TBW), ideal (IBW), or 
adjusted (ABW) body weight in kg.
}
\details{
This is derived using following:
- In principle, use IBW
- If total body weight (TBW) > 1.2*IBW, then use ABW
- If TBW < IBW, use TBW
}
\examples{
calc_dosing_weight(weight = 50, height = 170, sex = "female", age = 50)
}
