% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_lbw.R
\name{calc_lbw}
\alias{calc_lbw}
\title{Calculate lean body weight}
\usage{
calc_lbw(
  weight = NULL,
  bmi = NULL,
  sex = NULL,
  height = NULL,
  method = "green",
  digits = 1
)
}
\arguments{
\item{weight}{total body weight in kg}

\item{bmi}{bmi}

\item{sex}{sex, either `male` of `female`}

\item{height}{height in cm}

\item{method}{estimation method, either `green` (default), `boer`, `james`, `hume`}

\item{digits}{round to number of digits}
}
\value{
Returns a list of the following elements:
\item{value}{Lean Body Weight (LBW) in units of kg}
\item{unit}{Unit describing LBW, (kg)}
}
\description{
Get an estimate of lean body weight (LBW, in kg) based on weight, height, and sex.
}
\details{
Note: technically not the same as fat-free mass, although difference is small.

References:
`green`: Green and Duffull. Clin Pharmacol Ther 2002;
`james`: Absalom AR et al. Br J Anaesth 2009; 103:26-37.
         James W. Research on obesity. London: Her Majesty's Stationary Office, 1976.
`hume` : Hume R et al. J Clin Pathol. 1966 Jul; 19(4):389-91.
`boer` : Boer P et al. Am J Physiol 1984; 247: F632-5
}
\examples{
calc_lbw(weight = 80, height = 170, sex = "male")
calc_lbw(weight = 80, height = 170, sex = "male", method = "james")
}
