% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_neutropenia_grade.R
\name{calc_neutropenia_grade}
\alias{calc_neutropenia_grade}
\title{Calculate neutropenia grade from ANC}
\usage{
calc_neutropenia_grade(anc)
}
\arguments{
\item{anc}{absolute neutrophil count (ANC), in number per microliter}
}
\description{
Assigns neutropenia grade based on the National Cancer Institute system. Note
that while this system assigns a grade of 1 to an ANC between 1500-2000, the
term neutropenia is usually reserved for a grade of 2 or higher (an ANC of
<1500)
}
\examples{
calc_neutropenia_grade(
  anc = c(500, 1501)
)

}
\references{
\itemize{
  \item \href{https://link.springer.com/referenceworkentry/10.1007/978-3-642-16483-5_4052}{Neutropenia}: US National Cancer Institute's Common Toxicity Criteria
}
}
