% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convert_bilirubin_unit.R
\name{convert_bilirubin_unit}
\alias{convert_bilirubin_unit}
\title{Convert bilirubin from / to units}
\usage{
convert_bilirubin_unit(
  value,
  unit_in = valid_units("bilirubin"),
  unit_out = valid_units("bilirubin")
)
}
\arguments{
\item{value}{bilirubin measurements}

\item{unit_in}{from unit, e.g. `"g_l"`.}

\item{unit_out}{to flow unit, e.g. `"g_dl"`}
}
\description{
Accepted units are "mg_dl" and "micromol_l". Arguments supplied to `value` and
`unit_in` units must be of the same length. "To" unit must be of length 1.
#'
}
\examples{

## single values
convert_bilirubin_unit(1, "mg_dl", "micromol_l")

## vectorized
convert_bilirubin_unit(
  c(1, 1.1, 1.2),
  unit_in = "mg_dl",
  unit_out = "micromol_l"
)

}
