% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots-utility.R
\name{formatVarForPlotLabel}
\alias{formatVarForPlotLabel}
\title{Format parameter variable to be displayed 
in the labels of a plot}
\usage{
formatVarForPlotLabel(
  data,
  paramVar = NULL,
  paramGroupVar = NULL,
  revert = FALSE,
  width = 20
)
}
\arguments{
\item{data}{data.frame with data}

\item{paramVar}{string, variable of \code{data} with parameter}

\item{paramGroupVar}{(optional) character vector with variable(s) of 
\code{data} with grouping.\cr If specified, the parameters will be 
grouped by this(these) variable(s) in the y-axis.}

\item{revert}{logical, if TRUE revert the order of the levels of the variable}

\item{width}{max number of characters in the \code{paramVar} parameter.}
}
\value{
Vector with re-formatted \code{paramVar}, NULL if empty
}
\description{
The following workflow is used:
\enumerate{
\item format the variable as a factor
\item wrap it across multiple lines if needed
\item sort (its levels) according to a grouping variable
}
}
\author{
Laure Cougnaud
library(ggplot2)
data(dataADaMCDISCP01)
dataAE <- dataADaMCDISCP01$ADAE

# by default, groups are sorted alphabetically in ggplot2 (from bottom to top for an histogram)
ggplot(data = dataAE, aes(y = AEDECOD, fill = AEBODSYS)) + geom_histogram(stat="count")

# by default: labels are set to a new line if more than 20 characters:
dataAE$AEDECOD <- formatVarForPlotLabel(data = dataAE, paramVar = "AEDECOD")
levels(dataAE$AEDECOD)
ggplot(data = dataAE, aes(y = AEDECOD, fill = AEBODSYS)) + geom_histogram(stat="count")

# revert order of the variable
dataAE$AEDECOD <- formatVarForPlotLabel(data = dataAE, paramVar = "AEDECOD", revert = TRUE)
levels(dataAE$AEDECOD)
ggplot(data = dataAE, aes(y = AEDECOD, fill = AEBODSYS)) + geom_histogram(stat="count")

# group based on body system
dataAE$AEDECOD <- formatVarForPlotLabel(data = dataAE, paramVar = "AEDECOD", paramGroupVar = "AEBODSYS")
ggplot(data = dataAE, aes(y = AEDECOD, fill = AEBODSYS)) + geom_histogram(stat="count")
}
