% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/column_headers.R
\name{clin_column_headers}
\alias{clin_column_headers}
\title{Set the column headers of the output clintable}
\usage{
clin_column_headers(x, ...)
}
\arguments{
\item{x}{A clintable object}

\item{...}{Named arguments providing the column header text.
Separate levels of the header are determined using separate
elements of a character vector.}
}
\value{
A clintable object
}
\description{
This function allows you to apply column headers named arguments
and character vectors. Separate elements of the character vector
are converted to separate levels of the output table header.
The in which the headers are applied goes from top to bottom,
so if you provide 3 elements for a column header, the first
element is applied to the top and the second to the bottom.
If one variable has three levels and other variable only have
one or two, the columns with less levels to the header will bind
to the bottom. So a column with two levels will apply to the
second and third row, and a column with one level with apply
the bottom row. Spanners are determined using cells of the same
text value, where horizontal and vertical merging is performed.
}
\details{
The same result can be achieved using column labels on the
input dataframe to the clintable. If labels are present,
header levels will be separated using the delimitter "||" within
the label string.
}
\examples{

clintable(iris) |>
  clin_column_headers(
    Sepal.Length = c("Flowers", "Sepal", "Length"),
    Sepal.Width = c("Flowers", "Sepal", "Width"),
    Petal.Length = c("Petal", "Length"),
    Petal.Width = c("Petal", "Width")
  )

}
