% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/drive_transfer_bulk.R
\name{cloud_drive_download_bulk}
\alias{cloud_drive_download_bulk}
\title{Bulk download contents from Google Drive}
\usage{
cloud_drive_download_bulk(content, quiet = FALSE)
}
\arguments{
\item{content}{(data.frame) Output of \code{cloud_drive_ls()}}

\item{quiet}{All caution messages may be turned off by setting this parameter
to \code{TRUE}.}
}
\value{
Invisibly returns the input \code{content} dataframe.
}
\description{
Downloads multiple files from a Google Drive folder based on
the output dataframe from \link{cloud_drive_ls}. This function streamlines
the process of downloading multiple files by allowing you to filter and
select specific files from the Google Drive listing and then download
them in bulk.
}
\examples{
\dontshow{if (interactive() ) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# provided there's a folder called "toy_data" in the root of your project's
# Google Drive folder, and this folder contains "csv" files
cloud_drive_ls("toy_data") |> 
  filter(type == "csv") |> 
  cloud_drive_download_bulk()
  
# clean up
unlink("toy_data", recursive = TRUE)
  
\dontshow{\}) # examplesIf}
}
