% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Functions.R
\name{CCRls.coord}
\alias{CCRls.coord}
\title{Linear regression via coordinate descent with covariate clustering}
\usage{
CCRls.coord(Y, X, k, nC = 1, ...)
}
\arguments{
\item{Y}{vector of outcome variable}

\item{X}{matrix of covariates. Should not include 1's for the intercept}

\item{k}{number of clusters}

\item{nC}{first nC-1 covariates in X not to cluster. Must be at least 1 for the intercept}

\item{...}{additional parameters to be passed to \link[stats]{lm}}
}
\value{
\code{mobj}  the low dimension \link[stats]{lm} regression  object

\code{clus}  cluster assignments of covariates (excluding the first nC
covariates - including the intercept 1)
}
\description{
This function is a wrapper for \code{linrclus}. It requires less input.
}
\examples{
set.seed(14) #Generate data
N = 1000; (bets = rep(-2:2,4)); p = length(bets); X = matrix(rnorm(N*p),N,p)
Y = cbind(1,X)\%*\%matrix(c(0.5,bets),ncol = 1)
CCRls.coord(Y,X,k=5,nC=1)
}
