% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cmr_local.R
\name{cmr.local}
\alias{cmr.local}
\title{Spline analysis of cardiovascular magnetic resonance imaging}
\usage{
cmr.local(data, mask, input, quantiles = c(0.25, 0.75), cores = 1)
}
\arguments{
\item{data}{3d array of CMR signal}

\item{mask}{2d array of mask. Voxel with 0 or FALSE will be omitted from analysis}

\item{input}{input function}

\item{quantiles}{quantiles used for credible interval, default: c(0.25, 0.75)}

\item{cores}{number of cores to use in parallel computing}
}
\value{
list of mbf (point estimation) and ci (credible interval)
}
\description{
Spline analysis of cardiovascular magnetic resonance imaging
}
\examples{
\donttest{
oldpar <- par(no.readonly = TRUE)
 library(cmR)
 data(cmrsim)
 local.mbf=local.ci=array(NA,c(30,30,3))
 for (i in 1:3){
  mask=array(NA,c(30,30))
  mask[cmrdata_sim[,,i,1]!=0]=1
  temp=cmr.local(cmrdata_sim[,,i,], mask, input_sim, cores=2)
  local.mbf[,,i]=t(as.matrix(temp$mbf))
  local.ci[,,i]=t(as.matrix(temp$ci))
 }
 par(mfrow=c(2,1))
 imageMBF(maxresp_sim, zlim=c(0,5))
 imageMBF(local.mbf, zlim=c(0,5))
 imageMBF(local.ci, zlim=c(0,0.8))
par(oldpar)
}

}
