% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parse_help.R
\name{cmd_help_flags_similar}
\alias{cmd_help_flags_similar}
\title{Suggest alternative name by minimizing Levenshtein edit distance between valid and invalid arguments}
\usage{
cmd_help_flags_similar(
  command_flag_names,
  flags,
  .fun = NULL,
  distance_cutoff = 3L
)
}
\arguments{
\item{command_flag_names}{character vector of valid names (can be output of \code{\link{cmd_help_parse_flags}})}

\item{flags}{a vector names correspond to values to be checked against \code{command_flag_names}}

\item{.fun}{optional function to apply to \code{command_flag_names} and \code{flags}
before checking their values. If using a function to rename flags after
\code{cmd_list_interp}, use that same function here. Can be useful for parsing help
lines into R-friendly variable names for user-convenience. Can be function
or \code{rlang}-style formula definition (ie \code{.fun = ~{foo(.x)}} is the same as
\code{.fun = function(x){foo(x)}}). Note: if command_flag_names need additional
parsing after \code{\link{cmd_help_parse_flags}}, it is best to do that
preprocessing before passing them to this function.}

\item{distance_cutoff}{Levenshtein edit distance beyond which to suggest
??? instead of most similar argument (default = 3). Setting this too
liberally will result in nonsensical suggestions.}
}
\value{
named vector where names are names from \code{flags} and their values are the suggested best match from \code{command_flag_names}
}
\description{
Suggest alternative name by minimizing Levenshtein edit distance between valid and invalid arguments
}
\examples{
# with a flagsList, need to pass names()
flagsList <- list("output" = "somevalue", "missplld" = "anotherValue")
cmd_help_flags_similar(c("output", "misspelled"), names(flagsList))

command_flags <- c("long-flag-name")
flags <- c("long_flag_naee")
cmd_help_flags_similar(command_flags, flags, .fun = ~{gsub("-", "_", .x)})

# returns NULL if no errors
cmd_help_flags_similar(c("test"), "test")
}
