% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create-advanced-batch-body.R
\name{create_advanced_batch_body}
\alias{create_advanced_batch_body}
\title{Create POST request Body for batch search}
\usage{
create_advanced_batch_body(
  chemical_alphabet = "all",
  modifiers_type = "none",
  metabolites_type = "all-except-peptides",
  databases = "[\\"hmdb\\"]",
  masses_mode = "mz",
  ion_mode = "positive",
  adducts = "[\\"all\\"]",
  deuterium = "false",
  tolerance = "7.5",
  tolerance_mode = "ppm",
  masses = "[400.3432, 288.2174]",
  all_masses = "[]",
  retention_times = "[18.842525, 4.021555]",
  all_retention_times = "[]",
  composite_spectra = paste0("[[{ \\"mz\\": 400.3432, \\"intensity\\": 307034.88 }, ",
    "{ \\"mz\\": 311.20145, \\"intensity\\": 400.03336 }]]")
)
}
\arguments{
\item{chemical_alphabet}{"CHNOPS", "CHNOPSCL", "ALL"}

\item{modifiers_type}{"none", "NH3", "HCOO", "CH3COO", "HCOONH3", "CH3COONH3"}

\item{metabolites_type}{"all-except-peptides", "only-lipids", "all-including-peptides"}

\item{databases}{"all", "all-except-mine", "HMDB", "LipidMaps", "Metlin", "Kegg", "in-house", "mine"}

\item{masses_mode}{"neutral", "mz"}

\item{ion_mode}{"positive", "negative"}

\item{adducts}{for positive mode ["M+H", "M+2H", "M+Na", "M+K", "M+NH4", "M+H-H2O"] for negative mode ["M-H", "M+Cl", "M+FA-H", "M-H-H2O"], for neutral ["M"]}

\item{deuterium}{boolean 'true' 'false'}

\item{tolerance}{double (Range: [0..100])}

\item{tolerance_mode}{"ppm", "mDa"}

\item{masses}{double}

\item{all_masses}{array of doubles}

\item{retention_times}{double}

\item{all_retention_times}{array of doubles}

\item{composite_spectra}{array of arrays of spectra_object}
}
\value{
If all inputs are all correctly formatted, a dataframe will be returned for the result.
}
\description{
\code{create_advanced_batch_body} returns a string of advanced search POST request body.
}
