% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RCode.r
\name{log_f_rcpp3}
\alias{log_f_rcpp3}
\title{Compute the Log-Likelihood Function Proportional Hazards Model (PHM)}
\arguments{
\item{Params}{A numeric vector of parameters.}
}
\value{
A numeric value representing the log-likelihood.
}
\description{
This function computes the log-likelihood function for the parametric model (PHM Approach).
}
\examples{
library(cmpp)
set.seed(1984)
features <- matrix(rnorm(300, 1, 2), nrow = 100, ncol = 3)
delta1 <- sample(c(0, 1), 100, replace = TRUE)
delta2 <- 1 - delta1
x <- rexp(100, rate = 1/10)
Initialize(features, x, delta1, delta2, h = 1e-5)
params <- rep(0.001, 2 * (ncol(features) + 2))
log_likelihood <- log_f_rcpp3(params)
print(log_likelihood)

}
