% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/peak.R
\name{get_ccr_peaks}
\alias{get_ccr_peaks}
\title{Identify peaks of a cross correlation curve}
\usage{
get_ccr_peaks(comp, segments, seg_outlength, nseg = 1, npeaks = 5)
}
\arguments{
\item{comp}{a nueric vector, vector of the bullet comparison profile}

\item{segments}{list with basis segments and their corresponding indices in the original profile, obtianed by \code{get_segs()}}

\item{seg_outlength}{length of the enlarged segment}

\item{nseg}{integer. \code{nseg} = 3: the third segment in \code{segments}}

\item{npeaks}{integer. the number of peaks to be identified.}
}
\value{
a list consisting of:
\itemize{
\item \code{ccr}: the cross correlation curve
\item \code{adj_pos}: indices of the curve
\item \code{peaks_pos}: position of the identified peaks
\item \code{peaks_heights}: the cross correlation value (height of the curve) of the peaks
}
}
\description{
Given a comparison profile and a segment, \code{get_ccr_peaks} computes the
cross correlation curve and finds peaks of the curve.
}
\examples{
data("bullets")
land2_3 <- bullets$sigs[bullets$bulletland == "2-3"][[1]]
land1_2 <- bullets$sigs[bullets$bulletland == "1-2"][[1]]
x <- land2_3$sig
y <- land1_2$sig

segments <- get_segs(x, len = 50)

# compute ccf based on y and segment 7 with scale 1, then identify 5 highest peaks
ccrpeaks <- get_ccr_peaks(y, segments = segments, seg_outlength = 50,
                          nseg = 7, npeaks = 5)
}
