% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interface_abc.R
\name{create_abc_param}
\alias{create_abc_param}
\title{Convert Simulation Results to abc's Parameter Format}
\usage{
create_abc_param(sim_results, model)
}
\arguments{
\item{sim_results}{The simulation results as returned from
\code{\link[=simulate.coalmodel]{simulate}}.}

\item{model}{The model used for the simulations.}
}
\value{
A data.frame that can be used as \code{param}
argument of \code{\link[abc]{abc}}.
}
\description{
This function creates an object compatible with the \code{param}
argument of the \code{\link[abc]{abc}} function from coala's simulation
results.
}
\examples{
model <- coal_model(10, 1) +
  feat_mutation(par_prior("theta", rnorm(1, 5, .5))) +
  sumstat_sfs()
sim_results <- simulate(model, nsim = 2)
abc_param <- create_abc_param(sim_results, model)
print(abc_param)
}
\seealso{
For generating abc's summary statistics format:
\code{\link{create_abc_sumstat}}
}
