% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulator_scrm.R
\name{simulator_scrm}
\alias{simulator_scrm}
\alias{activate_scrm}
\title{Simulator: scrm}
\usage{
activate_scrm(priority = 400)
}
\arguments{
\item{priority}{The priority for this simulator. If multiple simulators
can simulate a model, the one with the highest priority will be used.}
}
\description{
This function adds the simulator 'scrm' to the list of available simulators.
It is provided via the CRAN package \pkg{scrm} and should be always installed
alongside with \pkg{coala}. It should be activated automatically, and this
function is only needed to change it \code{priority}.
}
\examples{
# Change scrm's priority
model <- coal_model(10, 1) + feat_mutation(5)
model # scrm is used by default
activate_scrm(250)
model # Now ms is used instead (if installed)
activate_scrm(550)
model # Now scrm is used again
}
\references{
Paul R. Staab, Sha Zhu, Dirk Metzler and Gerton Lunter (2015).
"scrm: efficiently simulating long sequences using the approximated
coalescent with recombination."
Bioinformatics, 31(10), pp. 1680-1682.
http://dx.doi.org/10.1093/bioinformatics/btu861
}
\seealso{
Other simulators: 
\code{\link{simulator_ms}},
\code{\link{simulator_msms}},
\code{\link{simulator_seqgen}}
}
\concept{simulators}
