% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{ex1}
\alias{ex1}
\title{Simulated Data for a Unidimensional Two-Parameter Item Response Model}
\format{
A list with the following elements:
\describe{
  \item{y}{Matrix of dichotomous responses.}
  \item{ystar}{Matrix of latent response variates.}
  \item{omega}{Subject-level effects of the experimental manipulation.}
  \item{omega_mu}{Vector of means for the subject-level effects of the
  experimental manipulation (1 by K * M).}
  \item{omega_sigma2}{Covariance matrix for the subject-level effects of the
  experimental manipulation (K * M by K * M).}
  \item{gamma}{Contrast codes matrix.}
  \item{lambda}{Matrix of item slope parameters.}
  \item{lambda_mu}{Vector of means for the item slope parameters
  (1 by JM).}
  \item{lambda_sigma2}{Covariance matrix for the item slope parameters
  (JM by JM).}
  \item{nu}{Mean of the item intercept parameters (scalar).}
  \item{nu_mu}{Mean of the item intercept parameters (scalar).}
  \item{nu_sigma2}{Variance of the item intercept parameters (scalar).}
  \item{zeta}{Condition-level prediction errors.}
  \item{zeta_mu}{Vector of means for the condition-level prediction errors
  (1 by J * M).}
  \item{zeta_sigma2}{Covariance matrix for the condition-level prediction
  errors (J * M by J * M).}
  \item{kappa}{Item guessing matrix  (K by IJ).}
  \item{condition}{Condition vector indiciting distinct conditions or time
  points.}
  \item{key}{Item key vector where 1 indicates target and 2 indicates
  distractor (IJ)}
  ...
}
}
\usage{
ex1
}
\description{
Data and parameters were simulated based on example 1 provided for the
sim_dich_response.R function.
}
\keyword{datasets}
