% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mhmc_sc.R
\name{mhmc_sc}
\alias{mhmc_sc}
\title{MHMC Parameter Estimates for Single Chain}
\usage{
mhmc_sc(
  y = y,
  obj_fun = NULL,
  link = NULL,
  est_omega = TRUE,
  est_lambda = TRUE,
  est_zeta = TRUE,
  est_nu = TRUE,
  omega0 = NULL,
  gamma0 = NULL,
  lambda0 = NULL,
  zeta0 = NULL,
  nu0 = NULL,
  kappa0 = NULL,
  omega_mu = NULL,
  omega_sigma2 = NULL,
  lambda_mu = NULL,
  lambda_sigma2 = NULL,
  zeta_mu = NULL,
  zeta_sigma2 = NULL,
  nu_mu = NULL,
  nu_sigma2 = NULL,
  burn = NULL,
  thin = NULL,
  min_tune = NULL,
  tune_int = NULL,
  max_tune = NULL,
  niter = NULL,
  weight = 1,
  verbose = FALSE
)
}
\arguments{
\item{y}{Item response matrix (K by IJ).}

\item{obj_fun}{A function that calculates predictions and log-likelihood
values for the selected model (character).}

\item{link}{Choose between "logit" or "probit" link functions.}

\item{est_omega}{Determines whether omega is estimated (logical).}

\item{est_lambda}{Determines whether nu is estimated (logical).}

\item{est_zeta}{Determines whether zeta is estimated (logical).}

\item{est_nu}{Determines whether nu is estimated (logical).}

\item{omega0}{Starting or known values for omega (K by MN).}

\item{gamma0}{Starting or known values for gamma (JM by MN).}

\item{lambda0}{Starting or known values for lambda (IJ by JM).}

\item{zeta0}{Starting or known values for  zeta (K by JM).}

\item{nu0}{Starting or known values for nu (IJ by 1).}

\item{kappa0}{Starting or known values for kappa (K by IJ).}

\item{omega_mu}{Mean prior for omega (1 by MN).}

\item{omega_sigma2}{Covariance prior for omega (MN by MN).}

\item{lambda_mu}{Mean prior for lambda (1 by JM)}

\item{lambda_sigma2}{Covariance prior for lambda (JM by JM)}

\item{zeta_mu}{Mean prior for zeta (1 by JM).}

\item{zeta_sigma2}{Covariance prior for zeta (JM by JM).}

\item{nu_mu}{Mean prior for nu (1 by 1).}

\item{nu_sigma2}{Covariance prior for nu (1 by 1).}

\item{burn}{Number of iterations at the beginning of an MCMC run to discard
(scalar).}

\item{thin}{Determines every nth observation retained (scalar).}

\item{min_tune}{Determines when tunning begins (scalar).}

\item{tune_int}{MHMC tuning interval (scalar).}

\item{max_tune}{Determines when tunning ends (scalar).}

\item{niter}{Number of iterations of the MHMC sampler.}

\item{weight}{Determines the weight of old versus new covariance matrix.}

\item{verbose}{Print progress of MHMC sampler.}
}
\value{
List with elements omega_draws (list of (niter - burn) / thin draws
for K by MN omega matrix), lambda_draws (list of (niter - burn) / thin draws
for IJ by JM lambda matrix), zeta_draws (list of (niter - burn) / thin draws
for K by JM zeta matrix), nu_draws (list of (niter - burn) / thin draws
for IJ by 1 nu matrix), cand_o_var (list of K final MN by MN candidate
proposal covariance matrices for omega for each examinee), cand_l_var (list
of IJ final JM by JM candidate proposal covariance matrices for lambda for
each item), cand_z_var (list of final JM by JM candidate proposal covariance
matrices for zeta for all examinees), and cand_n_var (list of IJ final scalar
candidate proposal variances for nu for all items).
}
\description{
This function uses the Metropolis-Hastings algorithm for a single chain to
calculate parameter estimates using the Markov Chain Monte Carlo method. The
method implemented follows Patz and Junker (1999). The approach to tuning the
scale and covariance matrix follows BDA and SAS 9.2 User Guide,
2nd Ed. "The MCMC Procedure: Tuning the Proposal Distribution".
}
\references{
Patz, R. J., & Junker, B. W. (1999). A Straightforward Approach to Markov
Chain Monte Carlo Methods for Item Response Models. Journal of Educational
and Behavioral Statistics, 24(2), 146.
}
\keyword{internal}
