% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cointReg.R
\docType{package}
\name{cointReg-package}
\alias{cointReg-package}
\title{The cointReg package}
\description{
Parameter Estimation and Inference in a Cointegrating Regression
}
\details{
See the vignette:\cr
\code{vignette("cointReg")}

See the DESCRIPTION:\cr
\code{help(package = cointReg)}

See the README:\cr
\url{https://github.com/aschersleben/cointReg/blob/master/README.md}

Open the package documentation page:\cr
\code{package?cointReg}

Further information and bug reporting:\cr
\url{https://github.com/aschersleben/cointReg}
}
\section{Functions}{

\itemize{
  \item \code{\link{cointReg}(method = c("FM", "D", "IM"), ...)}\cr
        General function to estimate parameters of
        the given model. Three methods are possible;
        they can be choosen directly by using one of the following
        functions:
  \itemize{
    \item \code{\link{cointRegFM}}: Fully Modified OLS
    \item \code{\link{cointRegD}}: Dynamic OLS
    \item \code{\link{cointRegIM}}: Integrated Modified OLS
  }
  \item \code{\link[=print.cointReg]{print}}\cr
        Print clear results.
  \item \code{\link[=plot.cointReg]{plot}}\cr
        Plot the residuals of a \code{cointReg} model.
  \item Helper functions:
  \itemize{
    \item Checking inputs and arguments:\cr
          \code{\link{checkObject}}, \code{\link{checkVars}}
    \item Calculation of bandwidth and long run variance:\cr
          \code{\link{getBandwidth}}, \code{\link{getBandwidthAnd}},
          \code{\link{getBandwidthNW}}\cr
          \code{\link{getLongRunVar}}, \code{\link{getLongRunWeights}}
    \item Additional D-OLS functions:\cr
          \code{\link{getLeadLag}}, \code{\link{makeLeadLagMatrix}},
          \code{\link{getModD}},  \code{\link{checkDoptions}}
  }
}
}

