% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot.cointmonitoR}
\alias{plot.cointmonitoR}
\title{Plot Method for Monitoring Procedures.}
\usage{
\method{plot}{cointmonitoR}(x, what = "test", type, main, xlab, ylab,
  axes = TRUE, legend = TRUE, main.val, xlab.val, ylab.val, lines = TRUE,
  ...)
}
\arguments{
\item{x}{[\code{cointmonitoR}]\cr
Object of class \code{"cointmonitoR"}, i.e. the result of
\code{\link{monitorStationarity}} or
\code{\link{monitorCointegration}}.}

\item{what}{[\code{character}]\cr
Whether to plot test statistics (\code{"test"}) (default) or the
values/residuals of the tested time series (\code{"values"} or
\code{"residuals"}) or \code{"both"}. Works only,
if \code{return.stats = TRUE} in the called function that to get \code{x}
(default setting).}

\item{type}{[\code{character}]\cr
Plot type (from \code{\link{plot}}). Default is \code{"l"}.}

\item{main, xlab, ylab}{[\code{character}]\cr
Title and axis titles (from \code{\link{plot}}). Default values will be
generated from the contents of \code{x}.}

\item{axes, legend}{[\code{logical}]\cr
Whether to add axes (from \code{\link{plot}}) and a legend to the plot.}

\item{main.val, xlab.val, ylab.val}{[\code{character}]\cr
Title and axis titles (from \code{\link{plot}}) for the second plot,
if generating both plots in one step (see argument \code{what}).
Default values will be generated from the contents of \code{x}.}

\item{lines}{[\code{logical}]\cr
Whether to add lines and annotations to the plot. Default is \code{TRUE}.}

\item{...}{[\code{any}]\cr
Further arguments passed to \code{\link{plot}}.}
}
\description{
Plotting objects of class \code{"cointmonitoR"}.
}
\examples{
### Monitoring stationarity (no break):
set.seed(1909)
x = rnorm(200)
test = monitorStationarity(x, m = 0.5)
plot(test)

oldpar = par(mfrow = c(2, 1), mar = c(4, 4, 1, 1))
plot(test, what = "both", legend = FALSE, main = "", main.val = "")
par(oldpar)


### Monitoring stationarity (break):
x = c(x[1:100], cumsum(rnorm(100, sd = 0.5)) + x[101:200])
test2 = monitorStationarity(x, m = 0.5)
plot(test2)

oldpar = par(mfrow = c(2, 1), mar = c(4, 4, 1, 1))
plot(test2, what = "both", legend = FALSE, main = "", main.val = "")
par(oldpar)


### Monitoring cointegration (no break):
set.seed(42)
x = data.frame(x1 = cumsum(rnorm(200)), x2 = cumsum(rnorm(200)))
eps1 = rnorm(200, sd = 2)
y = x$x1 - x$x2 + 10 + eps1
test3 = monitorCointegration(x = x, y = y, m = 0.5, model = "FM")
plot(test3)

oldpar = par(mfrow = c(2, 1), mar = c(4, 4, 1, 1))
plot(test3, what = "both", legend = FALSE, main = "", main.val = "")
par(oldpar)


### Monitoring cointegration (break):
eps2 = c(eps1[1:100], cumsum(eps1[101:200]))
y = x$x1 - x$x2 + 10 + eps2
test4 = monitorCointegration(x = x, y = y, m = 0.5, model = "FM")
plot(test4)

oldpar = par(mfrow = c(2, 1), mar = c(4, 4, 1, 1))
plot(test4, what = "both", legend = FALSE, main = "", main.val = "")
par(oldpar)

}
\seealso{
Other cointmonitoR: \code{\link{monitorCointegration}},
  \code{\link{monitorStationarity}},
  \code{\link{print.cointmonitoR}}
}

