% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wrappers.r
\name{collateral_mappers}
\alias{collateral_mappers}
\alias{map_safely}
\alias{map_quietly}
\alias{map_peacefully}
\alias{map2_safely}
\alias{map2_quietly}
\alias{map2_peacefully}
\alias{pmap_safely}
\alias{pmap_quietly}
\alias{pmap_peacefully}
\alias{future_map_safely}
\alias{future_map_quietly}
\alias{future_map_peacefully}
\alias{future_map2_safely}
\alias{future_map2_quietly}
\alias{future_map2_peacefully}
\alias{future_pmap_safely}
\alias{future_pmap_quietly}
\alias{future_pmap_peacefully}
\title{Map over a list while capturing side effects.}
\usage{
map_safely(.x, .f, otherwise = NULL, quiet = TRUE, ...)

map_quietly(.x, .f, ...)

map_peacefully(.x, .f, ...)

map2_safely(.x, .y, .f, otherwise = NULL, quiet = TRUE, ...)

map2_quietly(.x, .y, .f, ...)

map2_peacefully(.x, .y, .f, ...)

pmap_safely(.l, .f, otherwise = NULL, quiet = TRUE, ...)

pmap_quietly(.l, .f, ...)

pmap_peacefully(.l, .f, ...)

future_map_safely(.x, .f, otherwise = NULL, quiet = TRUE, ...)

future_map_quietly(.x, .f, ...)

future_map_peacefully(.x, .f, ...)

future_map2_safely(.x, .y, .f, otherwise = NULL, quiet = TRUE, ...)

future_map2_quietly(.x, .y, .f, ...)

future_map2_peacefully(.x, .y, .f, ...)

future_pmap_safely(.l, .f, otherwise = NULL, quiet = TRUE, ...)

future_pmap_quietly(.l, .f, ...)

future_pmap_peacefully(.l, .f, ...)
}
\arguments{
\item{.x}{A list or atomic vector.}

\item{.f}{A function, formula or atomic vector, as specified by
\code{\link[purrr:as_mapper]{purrr::as_mapper()}}.}

\item{otherwise}{Default value to use when an error occurs.}

\item{quiet}{Hide errors (\code{TRUE}, the default), or display them as they
occur?}

\item{...}{Other arguments supplied to \code{\link[purrr:map]{purrr::map()}} or its variants, or to
\code{\link[furrr:future_map]{furrr::future_map()}} or its variants..}

\item{.y}{A list or atomic vector, of the same length as \code{.x}.}

\item{.l}{A list of lists. The length of \code{.l} determines the number of
arguments that \code{.f} will be called with. List names will be used if
present.}
}
\value{
A list of the same length as \code{.x}. Each element of the returned list
is itself a named list, structured according to the captured side effects.
The Details section elaborates on these side effects.
}
\description{
\code{map_safely()}, \code{map_quietly()} and \code{map_peacefully()} are variants of
\code{\link[purrr:map]{purrr::map()}} that wrap the supplied function \code{.f} using \code{\link[purrr:safely]{purrr::safely()}}
and/or \code{purrr::quietly()} in order to capture various side effects. Lists
mapped in this way have an associated class added to them, allowing them to
succinctly summarise captured side effects when displayed in a tibble.
}
\details{
\code{map_safely()} will summarise the returned list with a fixed-width
string of two (spaced) columns:
\enumerate{
\item If a \code{result} component is present, \code{R} appears, and
\item If an \code{error} component is present, \code{E} appears.
}

If either component is missing, an underscore (\verb{_}) appears in its
place.

Similarly, \code{map_quietly()} will summarise the returned list with a
fixed-width string of four (spaced) columns:
\enumerate{
\item If a \code{result} component is present, \code{R} appears,
\item If an \code{output} component is present, \code{O} appears,
\item If a \code{messages} component is present, \code{M} appears, and
\item If a \code{warnings} component is present, \code{W} appears.
}

If any is missing, an underscore (\verb{_}) appears in its
place.

Variants for \href{https://purrr.tidyverse.org/reference/map2.html}{iterating over two or more inputs simultaneously}
are also provided and function identically to their \code{purrr} counterparts:
\enumerate{
\item \code{map2_safely()}
\item \code{map2_quietly()}
\item \code{pmap_safely()}
\item \code{pmap_quietly()}
}

Further variants, prefixed by \code{future_}, allow safe or quiet mapping to
happen in parallel if you have the \href{https://cran.r-project.org/package=furrr}{\code{furrr}}
package installed:
\enumerate{
\item \code{future_map_safely()}
\item \code{future_map_quietly()}
\item \code{future_map2_safely()}
\item \code{future_map2_quietly()}
\item \code{future_pmap_safely()}
\item \code{future_pmap_quietly()}
}
}
\examples{

library(tibble)
library(dplyr)
library(tidyr)
library(collateral)

# like map(), these can be used to iterate over vectors or lists
list("a", 10, 100) \%>\% map_safely(log)
list(5, -12, 103) \%>\% map_quietly(log)

# if you're using tibbles, you can also iterate over list-columns,
# such as nested data frames
mtcars \%>\%
  rownames_to_column(var = "car") \%>\%
  as_tibble() \%>\%
  select(car, cyl, disp, wt) \%>\%
  # spike some rows in cyl == 4 to make them fail
  mutate(wt = dplyr::case_when(
    wt < 2 ~ -wt,
    TRUE ~ wt)) \%>\%
  # nest and do some operations quietly()
  nest(data = -cyl) \%>\%
  mutate(qlog = map_quietly(data, ~ log(.$wt)))

}
