% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/colocboost_output.R
\name{get_colocboost_summary}
\alias{get_colocboost_summary}
\title{Get summary tables from a ColocBoost output.}
\source{
See detailed instructions in our tutorial portal:
\url{https://statfungen.github.io/colocboost/articles/Interpret_ColocBoost_Output.html}
}
\usage{
get_colocboost_summary(
  cb_output,
  summary_level = 1,
  outcome_names = NULL,
  interest_outcome = NULL,
  region_name = NULL,
  min_abs_corr_between_ucos = 0.5,
  median_abs_corr_between_ucos = 0.8
)
}
\arguments{
\item{cb_output}{Output object from \code{colocboost} analysis}

\item{summary_level}{When \code{summary_level = 1}, return basic summary table for colocalization results. See details in \code{get_ucos_summary} function when \code{summary_level = 2}.}

\item{outcome_names}{Optional vector of names of outcomes, which has the same order as Y in the original analysis.}

\item{interest_outcome}{Optional vector specifying a subset of outcomes from \code{outcome_names} to focus on. When provided, only colocalization events that include at least one of these outcomes will be returned.}

\item{region_name}{Optional character string. When provided, adds a column with this gene name to the output table for easier filtering in downstream analyses.}

\item{min_abs_corr_between_ucos}{Minimum absolute correlation for variants across two trait-specific (uncolocalized) effects to be considered colocalized. The default is 0.5.}

\item{median_abs_corr_between_ucos}{Median absolute correlation for variants across two trait-specific (uncolocalized) effects to be considered colocalized. The default is 0.8.}
}
\value{
A list containing results from the ColocBoost analysis:
\itemize{
\item When \code{summary_level = 1} (default):
\itemize{
\item \code{cos_summary}: A summary table for colocalization events with the following columns:
\itemize{
\item \code{focal_outcome}: The focal outcome being analyzed if exists. Otherwise, it is \code{FALSE}.
\item \code{colocalized_outcomes}: Colocalized outcomes for colocalization confidence set (CoS)
\item \code{cos_id}: Unique identifier for colocalization confidence set (CoS)
\item \code{purity}: Minimum absolute correlation of variables within colocalization confidence set (CoS)
\item \code{top_variable}: The variable with highest variant colocalization probability (VCP)
\item \code{top_variable_vcp}: Variant colocalization probability for the top variable
\item \code{cos_npc}: Normalized probability of colocalization
\item \code{min_npc_outcome}: Minimum normalized probability of colocalized traits
\item \code{n_variables}: Number of variables in colocalization confidence set (CoS)
\item \code{colocalized_index}: Indices of colocalized variables
\item \code{colocalized_variables}: List of colocalized variables
\item \code{colocalized_variables_vcp}: Variant colocalization probabilities for all colocalized variables
}
}
\item When \code{summary_level = 2}:
\itemize{
\item \code{cos_summary}: As described above
\item \code{ucos_summary}: A summary table for trait-specific (uncolocalized) effects
}
\item When \code{summary_level = 3}:
\itemize{
\item \code{cos_summary}: As described above
\item \code{ucos_summary}: A summary table for trait-specific (uncolocalized) effects
\item \code{ambiguous_cos_summary}: A summary table for ambiguous colocalization events from trait-specific effects
}
}
}
\description{
\code{get_colocboost_summary} get colocalization and trait-specific summary table
with or without the outcomes of interest.
}
\details{
When \code{summary_level = 1}, additional details and examples are introduced in \code{\link{get_cos_summary}}.
When \code{summary_level = 2} or \code{summary_level = 3}, additional details for trait-specific effects and ambiguous
colocalization events are included. See \code{\link{get_ucos_summary}} for details on these tables.
}
\examples{
# colocboost example
set.seed(1)
N <- 1000
P <- 100
# Generate X with LD structure
sigma <- 0.9^abs(outer(1:P, 1:P, "-"))
X <- MASS::mvrnorm(N, rep(0, P), sigma)
colnames(X) <- paste0("SNP", 1:P)
L <- 3
true_beta <- matrix(0, P, L)
true_beta[10, 1] <- 0.5 # SNP10 affects trait 1
true_beta[10, 2] <- 0.4 # SNP10 also affects trait 2 (colocalized)
true_beta[50, 2] <- 0.3 # SNP50 only affects trait 2
true_beta[80, 3] <- 0.6 # SNP80 only affects trait 3
Y <- matrix(0, N, L)
for (l in 1:L) {
  Y[, l] <- X \%*\% true_beta[, l] + rnorm(N, 0, 1)
}
res <- colocboost(X = X, Y = Y)
get_colocboost_summary(res)

}
\seealso{
Other colocboost_inference: 
\code{\link{get_ambiguous_colocalization}()},
\code{\link{get_robust_colocalization}()}
}
\concept{colocboost_inference}
