% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/colorify.R, R/colorify_pal.R
\name{colorify}
\alias{colorify}
\alias{colorify_pal}
\title{colorify: creation and modification of color/gradient palettes}
\usage{
colorify(
  n = NULL,
  colors = character(0),
  colours = colors,
  colors_lock = NULL,
  colors_names = character(0),
  colors_map = numeric(0),
  nn = n,
  hf = 1,
  sf = 1,
  lf = 1,
  rf = 1,
  gf = 1,
  bf = 1,
  hv = 0,
  sv = 0,
  lv = 0,
  rv = 0L,
  gv = 0L,
  bv = 0L,
  hmin = 0L,
  smin = 0L,
  lmin = 0L,
  rmin = 0L,
  gmin = 0L,
  bmin = 0L,
  hmax = 100L,
  smax = 100L,
  lmax = 100L,
  rmax = 100L,
  gmax = 100L,
  bmax = 100L,
  alpha = 1,
  seed = 42L,
  order = 1,
  plot = FALSE,
  export = FALSE,
  verbose = TRUE,
  ...
)

colorify_pal(
  colors = character(0),
  colors_lock = NULL,
  hf = 1,
  sf = 1,
  lf = 1,
  rf = 1,
  gf = 1,
  bf = 1,
  hv = 0,
  sv = 0,
  lv = 0,
  rv = 0L,
  gv = 0L,
  bv = 0L,
  hmin = 0L,
  smin = 0L,
  lmin = 0L,
  rmin = 0L,
  gmin = 0L,
  bmin = 0L,
  hmax = 100L,
  smax = 100L,
  lmax = 100L,
  rmax = 100L,
  gmax = 100L,
  bmax = 100L,
  alpha = 1,
  seed = 42L,
  order = 1,
  verbose = TRUE,
  ...
)
}
\arguments{
\item{n}{integer, default: NULL, else amount of colors to get, if palette selected and more colors requested they will be generated}

\item{colors}{character (vector), combination of selecting palette(s) by name (options: see display_palettes()), and/or vector of R color names and/or color hexcodes}

\item{colours}{colors}

\item{colors_lock}{numeric/boolean, default: NULL, numerical or logical index of colors (not) to be modified, if logical length != colors it will be cut or filled with TRUE/FALSE, prefix with '!' for logical vectors and '-' for numerical vectors to get inverse, see examples. If nn \%\% length(colors) == 0, i.e. if nn divisive by amount of colors without rest, set repeat given locking pattern}

\item{colors_names}{character, default: character(0), else return named vector of final colors}

\item{colors_map}{numeric, default numeric(0), else vector of n values for colors to make gradient map between and return function}

\item{nn}{integer (vector), default: n, else amount(s) of colors to output as gradient(s), after completing palette for n colors, if Inf return a callable function(n) generating colors}

\item{hf}{hue factor, default: 1, multiply values by factor, proportional to base value of 1}

\item{sf}{saturation factor, default: 1, multiply values by factor, proportional to base value of 1}

\item{lf}{lightness/brightness factor, default: 1, multiply values by factor, proportional to base value of 1}

\item{rf}{red factor, default: 1, multiply values by factor, proportional to base value of 1}

\item{gf}{green factor, default: 1, multiply values by factor, proportional to base value of 1}

\item{bf}{blue factor, default: 1, multiply values by factor, proportional to base value of 1}

\item{hv}{hue value, default: 0, add value to values, linear from base value of 0 to a maximum value of 100}

\item{sv}{saturation value, default: 0, add value to values, linear from base value of 0 to a maximum value of 100}

\item{lv}{lightness/brightness value, default: 0, add value to values, linear from base value of 0 to a maximum value of 100}

\item{rv}{red value, default: 0, add value to values, linear from base value of 0 to a maximum value of 100}

\item{gv}{green value, default: 0, add value to values, linear from base value of 0 to a maximum value of 100}

\item{bv}{blue value, default: 0, add value to values, linear from base value of 0 to a maximum value of 100}

\item{hmin}{hue minimum threshold, default: 0, expected range (0, 100)}

\item{smin}{saturation minimum threshold, default: 0, expected range (0, 100)}

\item{lmin}{lightness/brightness minimum threshold, default: 0, expected range (0, 100)}

\item{rmin}{red minimum threshold, default: 0, expected range (0, 100)}

\item{gmin}{green minimum threshold, default: 0, expected range (0, 100)}

\item{bmin}{blue minimum threshold, default: 0, expected range (0, 100)}

\item{hmax}{hue maximum threshold, default: 0, expected range (0, 100)}

\item{smax}{saturation maximum threshold, default: 0, expected range (0, 100)}

\item{lmax}{lightness/brightness maximum threshold, default: 0, expected range (0, 100)}

\item{rmax}{red maximum threshold, default: 0, expected range (0, 100)}

\item{gmax}{green maximum threshold, default: 0, expected range (0, 100)}

\item{bmax}{blue maximum threshold, default: 0, expected range (0, 100)}

\item{alpha}{numeric, sets color alpha values}

\item{seed}{integer, default: 42, set seed for generation of colors (n > given colors (palettes)) and colors ordering (see order)}

\item{order}{default: 1, numeric (vector) to adjust colors order, -1: reverse order, 0: seeded random order, >1: shift order, c(-1, >1): reverse then shift order, or numeric vector as many colors to set custom order (if longer, vector shortened to n colors)}

\item{plot}{default: FALSE, if TRUE or string, plot pie chart of color palette, if 'i' in string then plot image instead of pie,  if 'l' in string plot color index as labels}

\item{export}{default: FALSE, if TRUE: export = getwd(), if export = "string/", save hexcodes, rgb, and hsl values to export/colorify.csv}

\item{verbose}{default: TRUE, mentions if and how many colors are generated}

\item{...}{Use the ellipsis parameter to set color space and interpolate for grDevices::colorRampPalette()}
}
\value{
colorify: vector of color hexcodes

colorify_pal: callable function(n) for generating colors
}
\description{
The main colorify function can be used to generate or take colors that can then be modified with the same function call. See the vignette for extended examples.

Palette names are stripped of whitespace and lowered for name matching.
All RColorBrewer and Viridis palettes are included.
All grDevices plotting functions are provided as palettes, simply use: colors = "rainbow", "heat", "terrain", "topo" or "cm".
Viridis is recommended for (continuous) color-blind friendly paletets.
Okabe-Ito is recommended for discrete distinct colors (up to 8, generate if more colors are required).

Addition of values (.v) happens before multiplication with factors (.f). Intuitively, all given values are expected to be within range (0, 100), values will be scaled between (0, 1), as hsv() and rgb2hsv(maxColorValue = 1) require.

Note that parameter call order within the function call matters,
see examples and vignette.

A wrapper function around \code{\link{colorify}} to
turn it into a palette function compatible with
\code{\link[ggplot2]{discrete_scale}} and \code{\link[ggplot2]{scale_fill_gradientn}}.
}
\details{
Either generate theoretically maximally different colors, select an available R grDevices palette and/or modify the colors of the given gradient/palette
}
\examples{
## if parameters identical, change seed to change generation
colorify(10, plot = TRUE, seed = 1)
colorify(10, plot = TRUE, seed = 42)
## set colors, generate additional up to n
colorify(colors = c("red", "white", "blue"), n = 5, plot = TRUE)
## create gradients
colorify(colors = c("orange", "red", "white", "blue", "orange"), nn = 100, plot = TRUE)

## viridis gradient, lighten and saturate, darken
colorify(colors = "viridis", n = 100, plot = TRUE)
colorify(colors = "viridis", n = 10, plot = TRUE, lf = 1.5, sv = 10)
colorify(colors = "viridis", n = 10, plot = TRUE, lf = .9)
# TODO add examples for nn to vignette
colorify(colors = colorify(nn = Inf)(10), plot = TRUE) # basically random palette function
colorify(colors = colorify(nn = Inf, colors = c('red', 'white'))(10), plot = TRUE)
colorify(colors = colorify(nn = Inf, colors = c('red', 'white', 'blue'))(10), plot = TRUE)
colorify(colors = colorify(colors = 'viridis', nn = Inf)(50), plot = TRUE)

## palette selected by name in colors[1], 
## can add colors to selected palette, 
## if n < length, remove colors , if greater generate 
colorify(colors = c("Okabe-Ito", "red", "blue", "yellow"), plot = TRUE, n = 10)

## no adjustments to locked indices 
colorify(colors = "Okabe-Ito", colors_lock = c(FALSE,FALSE,TRUE,TRUE), plot = TRUE, rv = -300)
colorify(colors = "Okabe-Ito", colors_lock = c(FALSE,FALSE,TRUE,TRUE), plot = TRUE, rv = 300)

## colors_lock and inversing
colors <- colorify(5, plot = TRUE)
colorify(colors_lock = c(TRUE,TRUE), colors=colors, plot = TRUE, lf = .5)
colorify(colors_lock = ! c(TRUE,FALSE,TRUE), colors=colors, plot = TRUE, lf = .5)
colorify(colors_lock = c(3,4), colors=colors, plot = TRUE, lf = .5)
colorify(colors_lock = -c(3,4), colors=colors, plot = TRUE, lf = .5)

## rainbow
colorify(colors=grDevices::rainbow(100, s = .5), plot = TRUE)
colorify(colors="rainbow", n = 100, sf = .5, plot = TRUE)
colorify(colors=grDevices::rainbow(100, v = .5), plot = TRUE)
colorify(colors="rainbow", n = 100, lf = .5, plot = TRUE)
colorify(colors=grDevices::rainbow(100, start = .25, end = .75), plot = TRUE)
colorify(colors=grDevices::rainbow(100)[25:75], plot = TRUE)

## order
colorify(10, plot = TRUE, order = 1)  # default
colorify(10, plot = TRUE, order = 0)  # random
colorify(10, plot = TRUE, order = -1) # reverse
colorify(10, plot = TRUE, order = -3) # negative shift
colorify(10, plot = TRUE, order = 12) # > n

## call order
# Note that parameter call order within the function call matters, 
# see examples and vignette: 
# rv = 20 then rf = 1.2 can be different then 
# rf = 1.2 then rv = 20

# TODO add example to vignette
colors_map <- c(-5, 0, 10)
colors <- c("red", "white", "blue")
if (requireNamespace('circlize')) 
color_bar <- 
  circlize::colorRamp2(colors_map, colors)(seq(-5, 10, length.out = 100))
color_bar <- colorify(
  colors = colors, 
  colors_map = colors_map, 
  space = "Lab")(seq(-5, 10, length.out = 100)) # circlize::colorRamp2 style
graphics::image(1:100, 1, as.matrix(1:100), 
  col = color_bar, 
  axes = FALSE, 
  main = "Color Mapping using circlize::colorRamp2")
## named base R/hexcode
colorifunction <- colorify_pal(colors = c('red', '#FFFFFF', 'blue'))
colorify(colors = colorifunction(10), plot = TRUE)
## empty for random
colorifunction <- colorify_pal()
colorify(colors = colorifunction(10), plot = TRUE)
## named colors and palette(s)
colorifunction <- colorify_pal(colors = c('green', 'viridis', 'rainbow', 'yellow'), plot = TRUE)
colorify(colors = colorifunction(100), plot = TRUE)
}
\seealso{
\code{vignette("Introduction to coloRify")}

Browse vignettes with \code{vignette("Introduction to coloRify")}
}
