% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nhlcolors.r
\name{nhl.colors}
\alias{nhl.colors}
\title{NHL colors}
\usage{
nhl.colors(set = c("ducks", "coyotes", "bruins", "sabres", "flames",
  "hurricanes", "blackhawks", "avalanche", "blue_jackets", "stars", "red_wings",
  "oilers", "panthers", "kings", "wild", "canadiens", "predators", "devils",
  "islanders", "rangers", "senators", "flyers", "penguins", "sharks", "blues",
  "lightning", "maple_leafs", "canucks", "golden_knights", "capitals", "jets"))
}
\arguments{
\item{set}{Character string denoting an NHL team's color palette.}
}
\value{
Vector of character strings from the selected NHL team's color palette.
}
\description{
Function returns a vector of character strings from a selected NHL team's color palette. The team options are c("ducks", "coyotes", "bruins", "sabres", "flames", "hurricanes", "blackhawks", "avalanche", "blue_jackets", "stars", "red_wings", "oilers", "panthers", "kings", "wild", "canadiens", "predators", "devils", "islanders", "rangers", "senators", "flyers", "penguins", "sharks", "blues", "lightning", "maple_leafs", "canucks", "golden_knights", "capitals", "jets").
}
\examples{
\dontrun{
# Anaheim Ducks colors
(pal = nhl.colors("ducks"))
pie(rep(1, length(pal)), labels = sprintf("\%d (\%s)", seq_along(pal), pal), col = pal)

# Colorado Avalanche colors
(pal = nhl.colors("avalanche"))
pie(rep(1, length(pal)), labels = sprintf("\%d (\%s)", seq_along(pal), pal), col = pal)
}
}
\author{
Charles Crabtree \email{ccrabtr@umich.edu}
}
