% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/logged-artifact.R
\name{LoggedArtifactAsset}
\alias{LoggedArtifactAsset}
\title{An Artifact Asset object that was already logged.}
\description{
The \code{LoggedArtifactAsset} represent local or remote asset already logged with
particular \code{\link{Artifact}} to the Comet.
}
\section{Super class}{
\code{cometr::ArtifactAsset} -> \code{LoggedArtifactAsset}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-LoggedArtifactAsset-new}{\code{LoggedArtifactAsset$new()}}
\item \href{#method-LoggedArtifactAsset-get_id}{\code{LoggedArtifactAsset$get_id()}}
\item \href{#method-LoggedArtifactAsset-get_artifact_version_id}{\code{LoggedArtifactAsset$get_artifact_version_id()}}
\item \href{#method-LoggedArtifactAsset-get_artifact_id}{\code{LoggedArtifactAsset$get_artifact_id()}}
\item \href{#method-LoggedArtifactAsset-download}{\code{LoggedArtifactAsset$download()}}
}
}
\if{html}{\out{
<details><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="cometr" data-topic="ArtifactAsset" data-id="get_asset_type"><a href='../../cometr/html/ArtifactAsset.html#method-ArtifactAsset-get_asset_type'><code>cometr::ArtifactAsset$get_asset_type()</code></a></span></li>
<li><span class="pkg-link" data-pkg="cometr" data-topic="ArtifactAsset" data-id="get_link"><a href='../../cometr/html/ArtifactAsset.html#method-ArtifactAsset-get_link'><code>cometr::ArtifactAsset$get_link()</code></a></span></li>
<li><span class="pkg-link" data-pkg="cometr" data-topic="ArtifactAsset" data-id="get_local_path"><a href='../../cometr/html/ArtifactAsset.html#method-ArtifactAsset-get_local_path'><code>cometr::ArtifactAsset$get_local_path()</code></a></span></li>
<li><span class="pkg-link" data-pkg="cometr" data-topic="ArtifactAsset" data-id="get_logical_path"><a href='../../cometr/html/ArtifactAsset.html#method-ArtifactAsset-get_logical_path'><code>cometr::ArtifactAsset$get_logical_path()</code></a></span></li>
<li><span class="pkg-link" data-pkg="cometr" data-topic="ArtifactAsset" data-id="get_metadata"><a href='../../cometr/html/ArtifactAsset.html#method-ArtifactAsset-get_metadata'><code>cometr::ArtifactAsset$get_metadata()</code></a></span></li>
<li><span class="pkg-link" data-pkg="cometr" data-topic="ArtifactAsset" data-id="get_size"><a href='../../cometr/html/ArtifactAsset.html#method-ArtifactAsset-get_size'><code>cometr::ArtifactAsset$get_size()</code></a></span></li>
<li><span class="pkg-link" data-pkg="cometr" data-topic="ArtifactAsset" data-id="has_overwrite"><a href='../../cometr/html/ArtifactAsset.html#method-ArtifactAsset-has_overwrite'><code>cometr::ArtifactAsset$has_overwrite()</code></a></span></li>
<li><span class="pkg-link" data-pkg="cometr" data-topic="ArtifactAsset" data-id="is_remote"><a href='../../cometr/html/ArtifactAsset.html#method-ArtifactAsset-is_remote'><code>cometr::ArtifactAsset$is_remote()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-LoggedArtifactAsset-new"></a>}}
\if{latex}{\out{\hypertarget{method-LoggedArtifactAsset-new}{}}}
\subsection{Method \code{new()}}{
Creates a new \code{LoggedArtifactAsset} object with provided parameters.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LoggedArtifactAsset$new(
  logical_path,
  remote,
  size,
  metadata,
  asset_type,
  id,
  artifact_version_id,
  artifact_id,
  experiment_key,
  link = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{logical_path}}{the logical file name.}

\item{\code{remote}}{Is the asset a remote asset or not.}

\item{\code{size}}{The size if the asset of a non-remote asset.}

\item{\code{metadata}}{The metadata to be associated with the asset.}

\item{\code{asset_type}}{The type of asset.}

\item{\code{id}}{The ID of the asset}

\item{\code{artifact_version_id}}{The ID of Artifact Version associated with this asset.}

\item{\code{artifact_id}}{The ID of Artifact associated with this asset.}

\item{\code{experiment_key}}{The experiment key of the experiment that logged this asset.}

\item{\code{link}}{The remote link if the asset is remote.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-LoggedArtifactAsset-get_id"></a>}}
\if{latex}{\out{\hypertarget{method-LoggedArtifactAsset-get_id}{}}}
\subsection{Method \code{get_id()}}{
Asset unique ID
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LoggedArtifactAsset$get_id()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-LoggedArtifactAsset-get_artifact_version_id"></a>}}
\if{latex}{\out{\hypertarget{method-LoggedArtifactAsset-get_artifact_version_id}{}}}
\subsection{Method \code{get_artifact_version_id()}}{
The ID of Artifact Version associated with this asset
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LoggedArtifactAsset$get_artifact_version_id()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-LoggedArtifactAsset-get_artifact_id"></a>}}
\if{latex}{\out{\hypertarget{method-LoggedArtifactAsset-get_artifact_id}{}}}
\subsection{Method \code{get_artifact_id()}}{
The ID of Artifact associated with this asset
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LoggedArtifactAsset$get_artifact_id()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-LoggedArtifactAsset-download"></a>}}
\if{latex}{\out{\hypertarget{method-LoggedArtifactAsset-download}{}}}
\subsection{Method \code{download()}}{
Download the asset to a given full path or directory.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LoggedArtifactAsset$download(
  local_path = NULL,
  logical_path = NULL,
  overwrite_strategy = FALSE
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{local_path}}{The root folder to which to download. If \code{NULL}, will
download to a tmp path, otherwise will be either a root local path or a full local path.}

\item{\code{logical_path}}{The path relative to the root local_path to use
If \code{NULL} and \code{local_path==NULL} then no relative path is used, file would
just be a tmp path on local disk.
If \code{NULL} and \code{local_path!=NULL} then the local_path will be treated
as a root path, and the asset's \code{logical_path} will be appended to the
root path to form a full local path.}

\item{\code{overwrite_strategy}}{can be \code{FALSE}, "FAIL", "PRESERVE" or "OVERWRITE"
and follows the same semantics for overwrite strategy as artifact.download()}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{ArtifactAsset} holding information about downloaded asset data file.
}
}
}
