% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extractAudioFeatures.R
\name{extractAudioFeatures}
\alias{extractAudioFeatures}
\title{Title}
\usage{
extractAudioFeatures(
  wav.dir = getwd(),
  wav.fnames = NULL,
  windowSize = 25,
  windowShift = 12.5,
  windowType = "HAMMING",
  derivatives = 2,
  verbose = 1,
  recursive = FALSE
)
}
\arguments{
\item{wav.dir}{Directory of wav files for featurization}

\item{wav.fnames}{If wav.dir = NULL, a list of wav files for featurization}

\item{windowSize}{Size of window in milliseconds}

\item{windowShift}{Amoung to shift window in milliseconds}

\item{windowType}{Window type}

\item{derivatives}{Include no (0), first (1), or first and second (2) derivatives of features}

\item{verbose}{Verbose printing}

\item{recursive}{Recursively traverse directory for wav files}
}
\value{
An object of class preppedAudio, which consists of a list
    of `data`, `files`, and `control`. `data` is a list with
    elements corresponding to audio features for each of the input
    wav files, where each element is the audio features for the
    respective wav file. `files` contains metadata about each wav
    file for which audio features were extracted. `control` records
    arguments passed to extractAudioFeatures().
}
\description{
Title
}
\examples{
\dontrun{
wav.fnames = list.files(file.path('PATH/TO/WAV/FILES'),
                        pattern = 'wav$',
                        recursive = TRUE,
                        full.names = TRUE
                        )
audio <- extractAudioFeatures(wav.fnames = wav.fnames,
                              derivatives = 0
                              )
}

}
