% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zlm.wfit.R
\name{lm}
\alias{lm}
\title{Linear Model Fitting for Complex or Numeric Variables}
\usage{
lm(
  formula,
  data,
  subset,
  weights,
  na.action,
  method = "qr",
  model = TRUE,
  x = TRUE,
  y = FALSE,
  qr = TRUE,
  singular.ok = TRUE,
  contrasts = NULL,
  offset,
  ...
)
}
\arguments{
\item{formula}{an object of class "formula" (or one that can be coerced to that class): a symbolic description of the model to be fitted.
For complex variables there are restrictions on what kinds of formula can be comprehended. See \link{zmodel.matrix} for details.}

\item{data}{an optional data frame, list or environment (or object
    coercible by \code{\link{as.data.frame}} to a data frame) containing
    the variables in the model.  If not found in \code{data}, the
    variables are taken from \code{environment(formula)},
    typically the environment from which \code{lm} is called.}

\item{subset}{an optional vector specifying a subset of observations
    to be used in the fitting process.  (See additional details about how
    this argument interacts with data-dependent bases in the
    \sQuote{Details} section of the \code{\link[stats]{model.frame}}
    documentation.)}

\item{weights}{an optional vector of weights to be used in the fitting
    process.  Should be \code{NULL} or a numeric vector.
    If non-NULL, weighted least squares is used with weights
    \code{weights} (that is, minimizing \code{sum(w*e^2)}); otherwise
    ordinary least squares is used.  See also \sQuote{Details},}

\item{na.action}{a function which indicates what should happen
    when the data contain \code{NA}s.  The default is set by
    the \code{na.action} setting of \code{\link{options}}, and is
    \code{\link[stats]{na.fail}} if that is unset.  The \sQuote{factory-fresh}
    default is \code{\link[stats]{na.omit}}.  Another possible value is
    \code{NULL}, no action.  Value \code{\link[stats]{na.exclude}} can be useful.}

\item{method}{the method to be used; for fitting, currently only
    \code{method = "qr"} is supported; \code{method = "model.frame"} returns
    the model frame (the same as with \code{model = TRUE}, see below).}

\item{model}{logical. If \code{TRUE} return the model frame of the fit. Default is \code{TRUE}.}

\item{x}{logical. If \code{TRUE} return the model matrix of the fit. Default is \code{TRUE}.}

\item{y}{logical. Returns the response vector if \code{TRUE}. Defaults to \code{FALSE}.}

\item{qr}{logical. If \code{TRUE}, return the qr decomposition of the fit. Default is \code{TRUE}.}

\item{singular.ok}{logical. If \code{FALSE} (the default in S but
    not in \R) a singular fit is an error.}

\item{contrasts}{Not implemented for complex variables. See \link{zmodel.matrix} for details. Default is \code{NULL}}

\item{offset}{this can be used to specify an \emph{a priori} known
    component to be included in the linear predictor during fitting.
    This should be \code{NULL} or a numeric vector or matrix of extents
    matching those of the response.  One or more \code{\link[stats]{offset}} terms can be
    included in the formula instead or as well, and if more than one are
    specified their sum is used.  See \code{\link[stats]{model.offset}}.}

\item{...}{For \code{lm()}: additional arguments to be passed to the low level
    regression fitting functions (see below).}
}
\value{
Returns an object of class \code{c("zlm", "lm")}, or for multiple responses \code{c("zlm", "mlm", "lm")}.

The functions \link{summary} and \link{anova} are used to obtain and print a summary and analysis of variance table of the results.
The generic functions \link{coefficients}, \link{effects}, \link{fitted.values} and \link{residuals} extract various useful features of the value returned by lm.
Of course these things can also be accessed by simply using the get element symbol \code{$}.

Objects of class "zlm" are lists with the following components.
\item{\code{coefficients}}{a named vector of coefficients.}
\item{\code{residuals}}{the residuals, that is response minus fitted values.}
\item{\code{fitted.values}}{The fitted values, which are response values obtained by feeding the predictors into the model.}
\item{\code{rank}}{The numeric rank of the fitted linear model.}
\item{\code{weights}}{Numeric. The user supplied weights for the linear fit. If none were given, a vector of \code{1}s of length equal to that of the input data.}
\item{\code{df.residual}}{The residual degrees of freedom.}
\item{\code{call}}{The matched call.}
\item{\code{terms}}{the \link{terms} object used.}
\item{\code{contrasts}}{The contrasts used, as these are not supported this component will probably be \code{NULL}.}
\item{\code{xlevels}}{(only where relevant) a record of the levels of the factors used in fitting.}
\item{\code{offset}}{the offset used (missing if none were used).}
\item{\code{y}}{if requested, the response used.}
\item{\code{x}}{the model matrix used, unless requested to not return it.}
\item{\code{model}}{if requested, the model frame used.}
\item{\code{na.action}}{(where relevant) information returned by \link{model.frame} on the special handling of NAs.}
\item{\code{assign}}{Used by extractor functions like \link{summary} and \link{effects} to understand variable names. Not included in null fits.}
\item{\code{effects}}{Complex list. See \link{effects} for explanation. Not included in null fits.}
\item{\code{qr}}{unless declined, the output of the \link{qr} object created in the process of fitting. Not included in null fits.}
}
\description{
An adaptation of lm that is compatible with complex variables. If the response is not complex, it calls the standard \code{\link[stats:lm]{stats::lm()}}
Note: It is not capable of dealing with contrasts in the complex case.
The formula interpretation is also unable of handle algebraic expressions in \code{formula}.
}
\details{
Like \link[stats:lm]{stats::lm} the models are specified symbolically using the standard R formula notation:
\code{response ~ terms}
Meaning \code{response} is a linear combination of the predictor variables in \code{terms}.
For compatibility with complex numbers \code{complexlm::lm} uses \link{zmodel.matrix} to build the model matrix
from the model formula. As such it is limited to terms consisting of predictor names connected by \code{+} and/or \code{:} operators.
Anything more complicated will result in an error.

If response is a matrix, then then \code{lm()} fits a model to each column, and returns an object with class "mlm".

For complex input, this function calls \link{zlm.wfit}.
}
\note{
In \code{complexlm}, the \code{x} parameter defaults to \code{TRUE} so that followup
methods such as \link{predict.lm} have access to the model matrix.
}
\examples{
set.seed(4242)
n <- 8
slop <- complex(real = 4.23, imaginary = 2.323)
interc <- complex(real = 1.4, imaginary = 1.804)
e <- complex(real=rnorm(n)/6, imaginary=rnorm(n)/6)
xx <- complex(real= rnorm(n), imaginary= rnorm(n))
tframe <- data.frame(x= xx, y= slop*xx + interc + e)
lm(y ~ x, data = tframe, weights = rep(1,n))
}
\seealso{
\link{lm.fit}, \link{lm.wfit}, \link{zlm.wfit}, \link{zmodel.matrix}, \link{complexdqlrs}, \link[stats:lm]{stats::lm}
}
