% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zlm.wfit.R
\name{lm.fit}
\alias{lm.fit}
\alias{lm.wfit}
\title{Complex Variable Compatible Wrappers for \code{\link[stats:lmfit]{stats::lm.fit()}} and \code{\link[stats:lmfit]{stats::lm.wfit()}}}
\usage{
lm.fit(
  x,
  y,
  offset = NULL,
  method = "qr",
  tol = 1e-07,
  singular.ok = TRUE,
  ...
)

lm.wfit(
  x,
  y,
  w,
  offset = NULL,
  method = "qr",
  tol = 1e-07,
  singular.ok = TRUE,
  ...
)
}
\arguments{
\item{x}{design matrix of dimension \code{n * p}.}

\item{y}{vector of observations of length \code{n}, or a matrix with
    \code{n} rows.}

\item{offset}{(numeric of length \code{n}).  This can be used to
    specify an \emph{a priori} known component to be included in the
    linear predictor during fitting.}

\item{method}{currently, only \code{method = "qr"} is supported.}

\item{tol}{tolerance for the \code{\link{qr}} decomposition.  Default
    is 1e-7.}

\item{singular.ok}{logical. If \code{FALSE}, a singular model is an
    error.}

\item{...}{currently disregarded.}

\item{w}{vector of weights (length \code{n}) to be used in the fitting
    process for the \code{wfit} functions.  Weighted least squares is
    used with weights \code{w}, i.e., \code{sum(w * e^2)} is minimized.}
}
\value{
a \code{\link{list}} with components (for \code{lm.fit} and \code{lm.wfit})
  \item{coefficients}{\code{p} vector}
  \item{residuals}{\code{n} vector or matrix}
  \item{fitted.values}{\code{n} vector or matrix}
  \item{effects}{\code{n} vector of orthogonal single-\abbr{df}
    effects.  The first \code{rank} of them correspond to non-aliased
    coefficients, and are named accordingly.}
  \item{weights}{\code{n} vector --- \emph{only} for the \code{*wfit*}
    functions.}
  \item{rank}{integer, giving the rank}
  \item{df.residual}{degrees of freedom of residuals}
  \item{qr}{the QR decomposition, see \code{\link{qr}}.}

  Fits without any columns or non-zero weights do not have the
  \code{effects} and \code{qr} components.

  \code{.lm.fit()} returns a subset of the above, the \code{qr} part
  unwrapped, plus a logical component \code{pivoted} indicating if the
  underlying QR algorithm did pivot.
}
\description{
This function is just an if statement.
If the design matrix \code{x} is complex, \code{\link[=zlm.wfit]{zlm.wfit()}} is called.
Otherwise \code{\link[stats:lmfit]{stats::lm.fit()}} or \code{\link[stats:lmfit]{stats::lm.wfit()}} is called.
These functions are unlikely to be needed by end users, as they are called by \code{\link[=lm]{lm()}}.
}
\section{Functions}{
\itemize{
\item \code{lm.wfit()}: wrapper for weighted linear fitting function.

}}
\examples{
set.seed(4242)
n <- 6
p <- 2
slop <- complex(real = 4.23, imaginary = 2.323)
slop2 = complex(real = 2.1, imaginary = -3.9)
interc <- complex(real = 1.4, imaginary = 1.804)
e <- complex(real=rnorm(n)/6, imaginary=rnorm(n)/6)
desmat <- matrix(c(complex(real = rnorm(n * p), imaginary = rnorm(n * p)), rep(1, n)), n, p + 1)
y = desmat \%*\% c(slop, slop2, interc) + e
lm.fit(desmat, y)
}
