% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/medians.R
\name{range}
\alias{range}
\title{Range For Complex Objects}
\usage{
range(..., na.rm = FALSE, finite = FALSE)
}
\arguments{
\item{...}{Any complex, numeric, or character object}

\item{na.rm}{logical, indicates if \code{NA}'s should be removed.}

\item{finite}{logical, indicates if non-finite elements should be omitted.}
}
\value{
A complex vector describing a rectangle that all input values fall within.
}
\description{
This function extends \link[base:range]{base::range} to the field of complex numbers.
It returns a vector containing two complex numbers that are the diagonal points of a rectangle,
with sides parallel to the real and imaginary axes, that just contains all the complex numbers
given as arguments. If given non complex input it calls \link[base:range]{base::range}, please see the documentation
for that function for an explanation of its behavior with other input.
}
\examples{
set.seed(4242)
n <- 8
foo <- complex(real = rnorm(n), imaginary = rnorm(n))
range(foo)
}
\seealso{
\link[base:range]{base::range}
}
