#' NAICS 2002 Description
#'
#' A dataset containing the description of products under the NAICS 2002
#' classification.
#'
#' @format A data frame with 2341 rows and 2 variables:
#' \describe{
#'   \item{code}{NAICS 2002 Code}
#'   \item{desc}{NAICS 2002 Description}
#' }
#' @source \url{https://www.census.gov/eos/www/naics/}
"naics2002_desc"

#' NAICS 2007 Description
#'
#' A dataset containing the description of products under the NAICS 2007
#' classification.
#'
#' @format A data frame with 2328 rows and 2 variables:
#' \describe{
#'   \item{code}{NAICS 2007 Code}
#'   \item{desc}{NAICS 2007 Description}
#' }
#' @source \url{https://www.census.gov/eos/www/naics/}
"naics2007_desc"

#' NAICS 2012 Description
#'
#' A dataset containing the description of products under the NAICS 2012
#' classification.
#'
#' @format A data frame with 2229 rows and 2 variables:
#' \describe{
#'   \item{code}{NAICS 2012 Code}
#'   \item{desc}{NAICS 2012 Description}
#' }
#' @source \url{https://data.bls.gov/cew/apps/bls_naics/v2/bls_naics_app.htm#tab=download&naics=2012}
"naics2012_desc"

#' NAICS 2017 Description
#'
#' A dataset containing the description of products under the NAICS 2017
#' classification.
#'
#' @format A data frame with 2217 rows and 2 variables:
#' \describe{
#'   \item{code}{NAICS 2017 Code}
#'   \item{desc}{NAICS 2017 Description}
#' }
#' @source \url{https://data.bls.gov/cew/apps/bls_naics/v2/bls_naics_app.htm#tab=download&naics=2017}
"naics2017_desc"

#' HS0 Description
#'
#' A dataset containing the description of products under the HS0
#' classification.
#'
#' @format A data frame with 6380 rows and 2 variables:
#' \describe{
#'   \item{code}{HS0 Code}
#'   \item{desc}{HS0 Description}
#' }
#' @source \url{https://comtrade.un.org/data/cache/classificationH0.json}
"hs0_desc"

#' HS1 Description
#'
#' A dataset containing the description of products under the HS1
#' classification.
#'
#' @format A data frame with 6473 rows and 2 variables:
#' \describe{
#'   \item{code}{HS1 Code}
#'   \item{desc}{HS1 Description}
#' }
#' @source \url{https://comtrade.un.org/data/cache/classificationH1.json}
"hs1_desc"

#' HS2 Description
#'
#' A dataset containing the description of products under the HS2
#' classification.
#'
#' @format A data frame with 6568 rows and 2 variables:
#' \describe{
#'   \item{code}{HS2 Code}
#'   \item{desc}{HS2 Description}
#' }
#' @source \url{https://comtrade.un.org/data/cache/classificationH2.json}
"hs2_desc"

#' HS3 Description
#'
#' A dataset containing the description of products under the HS3
#' classification.
#'
#' @format A data frame with 6372 rows and 2 variables:
#' \describe{
#'   \item{code}{HS3 Code}
#'   \item{desc}{HS3 Description}
#' }
#' @source \url{https://comtrade.un.org/data/cache/classificationH3.json}
"hs3_desc"

#' HS4 Description
#'
#' A dataset containing the description of products under the HS4
#' classification.
#'
#' @format A data frame with 6528 rows and 2 variables:
#' \describe{
#'   \item{code}{HS4 Code}
#'   \item{desc}{HS4 Description}
#' }
#' @source \url{https://comtrade.un.org/data/cache/classificationH4.json}
"hs4_desc"

#' HS5 Description
#'
#' A dataset containing the description of products under the HS5
#' classification.
#'
#' @format A data frame with 6708 rows and 2 variables:
#' \describe{
#'   \item{code}{HS5 Code}
#'   \item{desc}{HS5 Description}
#' }
#' @source \url{https://comtrade.un.org/data/cache/classificationH5.json}
"hs5_desc"

#' HS (Combined) Description
#'
#' A dataset containing the description of products under the HS (Combined)
#' classification.
#'
#' @format A data frame with 7911 rows and 2 variables:
#' \describe{
#'   \item{code}{HS Code}
#'   \item{desc}{HS Description}
#' }
"hs_desc"

#' ISIC2 Description
#'
#' A dataset containing the description of products under the ISIC2
#' classification.
#'
#' @format A data frame with 276 rows and 2 variables:
#' \describe{
#'   \item{code}{ISIC2 Code}
#'   \item{desc}{ISIC2 Description}
#' }
#' @source \url{https://unstats.un.org/unsd/classifications/Econ/ISIC}
"isic2_desc"

#' ISIC3 Description
#'
#' A dataset containing the description of products under the ISIC3
#' classification.
#'
#' @format A data frame with 528 rows and 2 variables:
#' \describe{
#'   \item{code}{ISIC3 Code}
#'   \item{desc}{ISIC3 Description}
#' }
#' @source \url{https://unstats.un.org/unsd/classifications/Econ/ISIC}
"isic3_desc"

#' ISIC4 Description
#'
#' A dataset containing the description of products under the ISIC4
#' classification.
#'
#' @format A data frame with 766 rows and 2 variables:
#' \describe{
#'   \item{code}{ISIC4 Code}
#'   \item{desc}{ISIC4 Description}
#' }
#' @source \url{https://unstats.un.org/unsd/classifications/Econ/ISIC}
"isic4_desc"

#' SITC1 Description
#'
#' A dataset containing the description of products under the SITC1
#' classification.
#'
#' @format A data frame with 3024 rows and 2 variables:
#' \describe{
#'   \item{code}{SITC1 Code}
#'   \item{desc}{SITC1 Description}
#' }
#' @source \url{https://comtrade.un.org/data/cache/classificationS1.json}
"sitc1_desc"

#' SITC2 Description
#'
#' A dataset containing the description of products under the SITC2
#' classification.
#'
#' @format A data frame with 3988 rows and 2 variables:
#' \describe{
#'   \item{code}{SITC2 Code}
#'   \item{desc}{SITC2 Description}
#' }
#' @source \url{https://comtrade.un.org/data/cache/classificationS2.json}
"sitc2_desc"

#' SITC3 Description
#'
#' A dataset containing the description of products under the SITC3
#' classification.
#'
#' @format A data frame with 5951 rows and 2 variables:
#' \describe{
#'   \item{code}{SITC3 Code}
#'   \item{desc}{SITC3 Description}
#' }
#' @source \url{https://comtrade.un.org/data/cache/classificationS3.json}
"sitc3_desc"

#' SITC4 Description
#'
#' A dataset containing the description of products under the SITC4
#' classification.
#'
#' @format A data frame with 7239 rows and 2 variables:
#' \describe{
#'   \item{code}{SITC4 Code}
#'   \item{desc}{SITC4 Description}
#' }
#' @source \url{https://comtrade.un.org/data/cache/classificationS4.json}
"sitc4_desc"

#' BEC Description
#'
#' A dataset containing the description of products under the BEC
#' classification.
#'
#' @format A data frame with 29 rows and 2 variables:
#' \describe{
#'   \item{code}{BEC Code}
#'   \item{desc}{BEC Description}
#' }
#' @source \url{https://comtrade.un.org/data/cache/classificationBEC.json}
"bec_desc"

#' HS0-SITC1 Concordance
#'
#' A dataset containing concordances between HS0 and SITC1 classification.
#'
#' @format A data frame with 5012 rows and 8 variables:
#' \describe{
#'   \item{HS0_6d}{6-digit HS0 Code}
#'   \item{HS0_4d}{4-digit HS0 Code}
#'   \item{HS0_2d}{2-digit HS0 Code}
#'   \item{SITC1_5d}{5-digit SITC1 Code}
#'   \item{SITC1_4d}{4-digit SITC1 Code}
#'   \item{SITC1_3d}{3-digit SITC1 Code}
#'   \item{SITC1_2d}{2-digit SITC1 Code}
#'   \item{SITC1_1d}{1-digit SITC1 Code}
#' }
#' @source https://wits.worldbank.org/product_concordance.html
"hs0_sitc1"

#' HS0-SITC2 Concordance
#'
#' A dataset containing concordances between HS0 and SITC2 classification.
#'
#' @format A data frame with 5017 rows and 8 variables:
#' \describe{
#'   \item{HS0_6d}{6-digit HS0 Code}
#'   \item{HS0_4d}{4-digit HS0 Code}
#'   \item{HS0_2d}{2-digit HS0 Code}
#'   \item{SITC2_5d}{5-digit SITC2 Code}
#'   \item{SITC2_4d}{4-digit SITC2 Code}
#'   \item{SITC2_3d}{3-digit SITC2 Code}
#'   \item{SITC2_2d}{2-digit SITC2 Code}
#'   \item{SITC2_1d}{1-digit SITC2 Code}
#' }
#' @source https://wits.worldbank.org/product_concordance.html
"hs0_sitc2"

#' HS0-SITC3 Concordance
#'
#' A dataset containing concordances between HS0 and SITC3 classification.
#'
#' @format A data frame with 5017 rows and 8 variables:
#' \describe{
#'   \item{HS0_6d}{6-digit HS0 Code}
#'   \item{HS0_4d}{4-digit HS0 Code}
#'   \item{HS0_2d}{2-digit HS0 Code}
#'   \item{SITC3_5d}{5-digit SITC3 Code}
#'   \item{SITC3_4d}{4-digit SITC3 Code}
#'   \item{SITC3_3d}{3-digit SITC3 Code}
#'   \item{SITC3_2d}{2-digit SITC3 Code}
#'   \item{SITC3_1d}{1-digit SITC3 Code}
#' }
#' @source https://wits.worldbank.org/product_concordance.html
"hs0_sitc3"

#' HS0-SITC4 Concordance
#'
#' A dataset containing concordances between HS0 and SITC4 classification.
#'
#' @format A data frame with 5018 rows and 8 variables:
#' \describe{
#'   \item{HS0_6d}{6-digit HS0 Code}
#'   \item{HS0_4d}{4-digit HS0 Code}
#'   \item{HS0_2d}{2-digit HS0 Code}
#'   \item{SITC4_5d}{5-digit SITC4 Code}
#'   \item{SITC4_4d}{4-digit SITC4 Code}
#'   \item{SITC4_3d}{3-digit SITC4 Code}
#'   \item{SITC4_2d}{2-digit SITC4 Code}
#'   \item{SITC4_1d}{1-digit SITC4 Code}
#' }
#' @source https://wits.worldbank.org/product_concordance.html
"hs0_sitc4"

#' HS1-SITC1 Concordance
#'
#' A dataset containing concordances between HS1 and SITC1 classification.
#'
#' @format A data frame with 5106 rows and 8 variables:
#' \describe{
#'   \item{HS1_6d}{6-digit HS1 Code}
#'   \item{HS1_4d}{4-digit HS1 Code}
#'   \item{HS1_2d}{2-digit HS1 Code}
#'   \item{SITC1_5d}{5-digit SITC1 Code}
#'   \item{SITC1_4d}{4-digit SITC1 Code}
#'   \item{SITC1_3d}{3-digit SITC1 Code}
#'   \item{SITC1_2d}{2-digit SITC1 Code}
#'   \item{SITC1_1d}{1-digit SITC1 Code}
#' }
#' @source https://wits.worldbank.org/product_concordance.html
"hs1_sitc1"

#' HS1-SITC2 Concordance
#'
#' A dataset containing concordances between HS1 and SITC2 classification.
#'
#' @format A data frame with 5111 rows and 8 variables:
#' \describe{
#'   \item{HS1_6d}{6-digit HS1 Code}
#'   \item{HS1_4d}{4-digit HS1 Code}
#'   \item{HS1_2d}{2-digit HS1 Code}
#'   \item{SITC2_5d}{5-digit SITC2 Code}
#'   \item{SITC2_4d}{4-digit SITC2 Code}
#'   \item{SITC2_3d}{3-digit SITC2 Code}
#'   \item{SITC2_2d}{2-digit SITC2 Code}
#'   \item{SITC2_1d}{1-digit SITC2 Code}
#' }
#' @source https://wits.worldbank.org/product_concordance.html
"hs1_sitc2"

#' HS1-SITC3 Concordance
#'
#' A dataset containing concordances between HS1 and SITC3 classification.
#'
#' @format A data frame with 5111 rows and 8 variables:
#' \describe{
#'   \item{HS1_6d}{6-digit HS1 Code}
#'   \item{HS1_4d}{4-digit HS1 Code}
#'   \item{HS1_2d}{2-digit HS1 Code}
#'   \item{SITC3_5d}{5-digit SITC3 Code}
#'   \item{SITC3_4d}{4-digit SITC3 Code}
#'   \item{SITC3_3d}{3-digit SITC3 Code}
#'   \item{SITC3_2d}{2-digit SITC3 Code}
#'   \item{SITC3_1d}{1-digit SITC3 Code}
#' }
#' @source https://wits.worldbank.org/product_concordance.html
"hs1_sitc3"

#' HS1-SITC4 Concordance
#'
#' A dataset containing concordances between HS1 and SITC4 classification.
#'
#' @format A data frame with 5111 rows and 8 variables:
#' \describe{
#'   \item{HS1_6d}{6-digit HS1 Code}
#'   \item{HS1_4d}{4-digit HS1 Code}
#'   \item{HS1_2d}{2-digit HS1 Code}
#'   \item{SITC4_5d}{5-digit SITC4 Code}
#'   \item{SITC4_4d}{4-digit SITC4 Code}
#'   \item{SITC4_3d}{3-digit SITC4 Code}
#'   \item{SITC4_2d}{2-digit SITC4 Code}
#'   \item{SITC4_1d}{1-digit SITC4 Code}
#' }
#' @source https://wits.worldbank.org/product_concordance.html
"hs1_sitc4"

#' HS2-SITC1 Concordance
#'
#' A dataset containing concordances between HS2 and SITC1 classification.
#'
#' @format A data frame with 5217 rows and 8 variables:
#' \describe{
#'   \item{HS2_6d}{6-digit HS2 Code}
#'   \item{HS2_4d}{4-digit HS2 Code}
#'   \item{HS2_2d}{2-digit HS2 Code}
#'   \item{SITC1_5d}{5-digit SITC1 Code}
#'   \item{SITC1_4d}{4-digit SITC1 Code}
#'   \item{SITC1_3d}{3-digit SITC1 Code}
#'   \item{SITC1_2d}{2-digit SITC1 Code}
#'   \item{SITC1_1d}{1-digit SITC1 Code}
#' }
#' @source https://wits.worldbank.org/product_concordance.html
"hs2_sitc1"

#' HS2-SITC2 Concordance
#'
#' A dataset containing concordances between HS2 and SITC2 classification.
#'
#' @format A data frame with 5222 rows and 8 variables:
#' \describe{
#'   \item{HS2_6d}{6-digit HS2 Code}
#'   \item{HS2_4d}{4-digit HS2 Code}
#'   \item{HS2_2d}{2-digit HS2 Code}
#'   \item{SITC2_5d}{5-digit SITC2 Code}
#'   \item{SITC2_4d}{4-digit SITC2 Code}
#'   \item{SITC2_3d}{3-digit SITC2 Code}
#'   \item{SITC2_2d}{2-digit SITC2 Code}
#'   \item{SITC2_1d}{1-digit SITC2 Code}
#' }
#' @source https://wits.worldbank.org/product_concordance.html
"hs2_sitc2"

#' HS2-SITC3 Concordance
#'
#' A dataset containing concordances between HS2 and SITC3 classification.
#'
#' @format A data frame with 5222 rows and 8 variables:
#' \describe{
#'   \item{HS2_6d}{6-digit HS2 Code}
#'   \item{HS2_4d}{4-digit HS2 Code}
#'   \item{HS2_2d}{2-digit HS2 Code}
#'   \item{SITC3_5d}{5-digit SITC3 Code}
#'   \item{SITC3_4d}{4-digit SITC3 Code}
#'   \item{SITC3_3d}{3-digit SITC3 Code}
#'   \item{SITC3_2d}{2-digit SITC3 Code}
#'   \item{SITC3_1d}{1-digit SITC3 Code}
#' }
#' @source https://wits.worldbank.org/product_concordance.html
"hs2_sitc3"

#' HS2-SITC4 Concordance
#'
#' A dataset containing concordances between HS2 and SITC4 classification.
#'
#' @format A data frame with 5220 rows and 8 variables:
#' \describe{
#'   \item{HS2_6d}{6-digit HS2 Code}
#'   \item{HS2_4d}{4-digit HS2 Code}
#'   \item{HS2_2d}{2-digit HS2 Code}
#'   \item{SITC4_5d}{5-digit SITC4 Code}
#'   \item{SITC4_4d}{4-digit SITC4 Code}
#'   \item{SITC4_3d}{3-digit SITC4 Code}
#'   \item{SITC4_2d}{2-digit SITC4 Code}
#'   \item{SITC4_1d}{1-digit SITC4 Code}
#' }
#' @source https://wits.worldbank.org/product_concordance.html
"hs2_sitc4"

#' HS3-SITC1 Concordance
#'
#' A dataset containing concordances between HS3 and SITC1 classification.
#'
#' @format A data frame with 5045 rows and 8 variables:
#' \describe{
#'   \item{HS3_6d}{6-digit HS3 Code}
#'   \item{HS3_4d}{4-digit HS3 Code}
#'   \item{HS3_2d}{2-digit HS3 Code}
#'   \item{SITC1_5d}{5-digit SITC1 Code}
#'   \item{SITC1_4d}{4-digit SITC1 Code}
#'   \item{SITC1_3d}{3-digit SITC1 Code}
#'   \item{SITC1_2d}{2-digit SITC1 Code}
#'   \item{SITC1_1d}{1-digit SITC1 Code}
#' }
#' @source https://wits.worldbank.org/product_concordance.html
"hs3_sitc1"

#' HS3-SITC2 Concordance
#'
#' A dataset containing concordances between HS3 and SITC2 classification.
#'
#' @format A data frame with 5050 rows and 8 variables:
#' \describe{
#'   \item{HS3_6d}{6-digit HS3 Code}
#'   \item{HS3_4d}{4-digit HS3 Code}
#'   \item{HS3_2d}{2-digit HS3 Code}
#'   \item{SITC2_5d}{5-digit SITC2 Code}
#'   \item{SITC2_4d}{4-digit SITC2 Code}
#'   \item{SITC2_3d}{3-digit SITC2 Code}
#'   \item{SITC2_2d}{2-digit SITC2 Code}
#'   \item{SITC2_1d}{1-digit SITC2 Code}
#' }
#' @source https://wits.worldbank.org/product_concordance.html
"hs3_sitc2"

#' HS3-SITC3 Concordance
#'
#' A dataset containing concordances between HS3 and SITC3 classification.
#'
#' @format A data frame with 5050 rows and 8 variables:
#' \describe{
#'   \item{HS3_6d}{6-digit HS3 Code}
#'   \item{HS3_4d}{4-digit HS3 Code}
#'   \item{HS3_2d}{2-digit HS3 Code}
#'   \item{SITC3_5d}{5-digit SITC3 Code}
#'   \item{SITC3_4d}{4-digit SITC3 Code}
#'   \item{SITC3_3d}{3-digit SITC3 Code}
#'   \item{SITC3_2d}{2-digit SITC3 Code}
#'   \item{SITC3_1d}{1-digit SITC3 Code}
#' }
#' @source https://wits.worldbank.org/product_concordance.html
"hs3_sitc3"

#' HS3-SITC4 Concordance
#'
#' A dataset containing concordances between HS3 and SITC4 classification.
#'
#' @format A data frame with 5050 rows and 8 variables:
#' \describe{
#'   \item{HS3_6d}{6-digit HS3 Code}
#'   \item{HS3_4d}{4-digit HS3 Code}
#'   \item{HS3_2d}{2-digit HS3 Code}
#'   \item{SITC4_5d}{5-digit SITC4 Code}
#'   \item{SITC4_4d}{4-digit SITC4 Code}
#'   \item{SITC4_3d}{3-digit SITC4 Code}
#'   \item{SITC4_2d}{2-digit SITC4 Code}
#'   \item{SITC4_1d}{1-digit SITC4 Code}
#' }
#' @source https://wits.worldbank.org/product_concordance.html
"hs3_sitc4"

#' HS4-SITC1 Concordance
#'
#' A dataset containing concordances between HS4 and SITC1 classification.
#'
#' @format A data frame with 5199 rows and 8 variables:
#' \describe{
#'   \item{HS4_6d}{6-digit HS4 Code}
#'   \item{HS4_4d}{4-digit HS4 Code}
#'   \item{HS4_2d}{2-digit HS4 Code}
#'   \item{SITC1_5d}{5-digit SITC1 Code}
#'   \item{SITC1_4d}{4-digit SITC1 Code}
#'   \item{SITC1_3d}{3-digit SITC1 Code}
#'   \item{SITC1_2d}{2-digit SITC1 Code}
#'   \item{SITC1_1d}{1-digit SITC1 Code}
#' }
#' @source \url{https://unstats.un.org/unsd/trade/classifications/correspondence-tables.asp}
"hs4_sitc1"

#' HS4-SITC2 Concordance
#'
#' A dataset containing concordances between HS4 and SITC2 classification.
#'
#' @format A data frame with 5205 rows and 8 variables:
#' \describe{
#'   \item{HS4_6d}{6-digit HS4 Code}
#'   \item{HS4_4d}{4-digit HS4 Code}
#'   \item{HS4_2d}{2-digit HS4 Code}
#'   \item{SITC2_5d}{5-digit SITC2 Code}
#'   \item{SITC2_4d}{4-digit SITC2 Code}
#'   \item{SITC2_3d}{3-digit SITC2 Code}
#'   \item{SITC2_2d}{2-digit SITC2 Code}
#'   \item{SITC2_1d}{1-digit SITC2 Code}
#' }
#' @source \url{https://unstats.un.org/unsd/trade/classifications/correspondence-tables.asp}
"hs4_sitc2"

#' HS4-SITC3 Concordance
#'
#' A dataset containing concordances between HS4 and SITC3 classification.
#'
#' @format A data frame with 5206 rows and 8 variables:
#' \describe{
#'   \item{HS4_6d}{6-digit HS4 Code}
#'   \item{HS4_4d}{4-digit HS4 Code}
#'   \item{HS4_2d}{2-digit HS4 Code}
#'   \item{SITC3_5d}{5-digit SITC3 Code}
#'   \item{SITC3_4d}{4-digit SITC3 Code}
#'   \item{SITC3_3d}{3-digit SITC3 Code}
#'   \item{SITC3_2d}{2-digit SITC3 Code}
#'   \item{SITC3_1d}{1-digit SITC3 Code}
#' }
#' @source \url{https://unstats.un.org/unsd/trade/classifications/correspondence-tables.asp}
"hs4_sitc3"

#' HS4-SITC4 Concordance
#'
#' A dataset containing concordances between HS4 and SITC4 classification.
#'
#' @format A data frame with 5205 rows and 8 variables:
#' \describe{
#'   \item{HS4_6d}{6-digit HS4 Code}
#'   \item{HS4_4d}{4-digit HS4 Code}
#'   \item{HS4_2d}{2-digit HS4 Code}
#'   \item{SITC4_5d}{5-digit SITC4 Code}
#'   \item{SITC4_4d}{4-digit SITC4 Code}
#'   \item{SITC4_3d}{3-digit SITC4 Code}
#'   \item{SITC4_2d}{2-digit SITC4 Code}
#'   \item{SITC4_1d}{1-digit SITC4 Code}
#' }
#' @source \url{https://unstats.un.org/unsd/trade/classifications/correspondence-tables.asp}
"hs4_sitc4"

#' HS5-SITC1 Concordance
#'
#' A dataset containing concordances between HS5 and SITC1 classification.
#'
#' @format A data frame with 5381 rows and 8 variables:
#' \describe{
#'   \item{HS5_6d}{6-digit HS5 Code}
#'   \item{HS5_4d}{4-digit HS5 Code}
#'   \item{HS5_2d}{2-digit HS5 Code}
#'   \item{SITC1_5d}{5-digit SITC1 Code}
#'   \item{SITC1_4d}{4-digit SITC1 Code}
#'   \item{SITC1_3d}{3-digit SITC1 Code}
#'   \item{SITC1_2d}{2-digit SITC1 Code}
#'   \item{SITC1_1d}{1-digit SITC1 Code}
#' }
#' @source \url{https://unstats.un.org/unsd/trade/classifications/correspondence-tables.asp}
"hs5_sitc1"

#' HS5-SITC2 Concordance
#'
#' A dataset containing concordances between HS5 and SITC2 classification.
#'
#' @format A data frame with 5387 rows and 8 variables:
#' \describe{
#'   \item{HS5_6d}{6-digit HS5 Code}
#'   \item{HS5_4d}{4-digit HS5 Code}
#'   \item{HS5_2d}{2-digit HS5 Code}
#'   \item{SITC2_5d}{5-digit SITC2 Code}
#'   \item{SITC2_4d}{4-digit SITC2 Code}
#'   \item{SITC2_3d}{3-digit SITC2 Code}
#'   \item{SITC2_2d}{2-digit SITC2 Code}
#'   \item{SITC2_1d}{1-digit SITC2 Code}
#' }
#' @source \url{https://unstats.un.org/unsd/trade/classifications/correspondence-tables.asp}
"hs5_sitc2"

#' HS5-SITC3 Concordance
#'
#' A dataset containing concordances between HS5 and SITC3 classification.
#'
#' @format A data frame with 5387 rows and 8 variables:
#' \describe{
#'   \item{HS5_6d}{6-digit HS5 Code}
#'   \item{HS5_4d}{4-digit HS5 Code}
#'   \item{HS5_2d}{2-digit HS5 Code}
#'   \item{SITC3_5d}{5-digit SITC3 Code}
#'   \item{SITC3_4d}{4-digit SITC3 Code}
#'   \item{SITC3_3d}{3-digit SITC3 Code}
#'   \item{SITC3_2d}{2-digit SITC3 Code}
#'   \item{SITC3_1d}{1-digit SITC3 Code}
#' }
#' @source \url{https://unstats.un.org/unsd/trade/classifications/correspondence-tables.asp}
"hs5_sitc3"

#' HS5-SITC4 Concordance
#'
#' A dataset containing concordances between HS5 and SITC4 classification.
#'
#' @format A data frame with 5387 rows and 8 variables:
#' \describe{
#'   \item{HS5_6d}{6-digit HS5 Code}
#'   \item{HS5_4d}{4-digit HS5 Code}
#'   \item{HS5_2d}{2-digit HS5 Code}
#'   \item{SITC4_5d}{5-digit SITC4 Code}
#'   \item{SITC4_4d}{4-digit SITC4 Code}
#'   \item{SITC4_3d}{3-digit SITC4 Code}
#'   \item{SITC4_2d}{2-digit SITC4 Code}
#'   \item{SITC4_1d}{1-digit SITC4 Code}
#' }
#' @source \url{https://unstats.un.org/unsd/trade/classifications/correspondence-tables.asp}
"hs5_sitc4"

#' HS-SITC1 Concordance
#'
#' A dataset containing concordances between HS (combined) and SITC1 classification.
#'
#' @format A data frame with 7683 rows and 8 variables:
#' \describe{
#'   \item{HS_6d}{6-digit HS Code}
#'   \item{HS_4d}{4-digit HS Code}
#'   \item{HS_2d}{2-digit HS Code}
#'   \item{SITC1_5d}{5-digit SITC1 Code}
#'   \item{SITC1_4d}{4-digit SITC1 Code}
#'   \item{SITC1_3d}{3-digit SITC1 Code}
#'   \item{SITC1_2d}{2-digit SITC1 Code}
#'   \item{SITC1_1d}{1-digit SITC1 Code}
#' }
#' @source https://wits.worldbank.org/product_concordance.html; \url{https://unstats.un.org/unsd/trade/classifications/correspondence-tables.asp}
"hs_sitc1"

#' HS-SITC2 Concordance
#'
#' A dataset containing concordances between HS (combined) and SITC2 classification.
#'
#' @format A data frame with 8346 rows and 8 variables:
#' \describe{
#'   \item{HS_6d}{6-digit HS Code}
#'   \item{HS_4d}{4-digit HS Code}
#'   \item{HS_2d}{2-digit HS Code}
#'   \item{SITC2_5d}{5-digit SITC2 Code}
#'   \item{SITC2_4d}{4-digit SITC2 Code}
#'   \item{SITC2_3d}{3-digit SITC2 Code}
#'   \item{SITC2_2d}{2-digit SITC2 Code}
#'   \item{SITC2_1d}{1-digit SITC2 Code}
#' }
#' @source https://wits.worldbank.org/product_concordance.html; \url{https://unstats.un.org/unsd/trade/classifications/correspondence-tables.asp}
"hs_sitc2"

#' HS-SITC3 Concordance
#'
#' A dataset containing concordances between HS (combined) and SITC3 classification.
#'
#' @format A data frame with 6826 rows and 8 variables:
#' \describe{
#'   \item{HS_6d}{6-digit HS Code}
#'   \item{HS_4d}{4-digit HS Code}
#'   \item{HS_2d}{2-digit HS Code}
#'   \item{SITC3_5d}{5-digit SITC3 Code}
#'   \item{SITC3_4d}{4-digit SITC3 Code}
#'   \item{SITC3_3d}{3-digit SITC3 Code}
#'   \item{SITC3_2d}{2-digit SITC3 Code}
#'   \item{SITC3_1d}{1-digit SITC3 Code}
#' }
#' @source https://wits.worldbank.org/product_concordance.html; \url{https://unstats.un.org/unsd/trade/classifications/correspondence-tables.asp}
"hs_sitc3"

#' HS-SITC4 Concordance
#'
#' A dataset containing concordances between HS (combined) and SITC4 classification.
#'
#' @format A data frame with 6582 rows and 8 variables:
#' \describe{
#'   \item{HS_6d}{6-digit HS Code}
#'   \item{HS_4d}{4-digit HS Code}
#'   \item{HS_2d}{2-digit HS Code}
#'   \item{SITC4_5d}{5-digit SITC4 Code}
#'   \item{SITC4_4d}{4-digit SITC4 Code}
#'   \item{SITC4_3d}{3-digit SITC4 Code}
#'   \item{SITC4_2d}{2-digit SITC4 Code}
#'   \item{SITC4_1d}{1-digit SITC4 Code}
#' }
#' @source https://wits.worldbank.org/product_concordance.html; \url{https://unstats.un.org/unsd/trade/classifications/correspondence-tables.asp}
"hs_sitc4"

#' HS-NAICS Concordance
#'
#' A dataset containing concordances between HS (combined) and NAICS (combined) classification.
#'
#' @format A data frame with 10399 rows and 6 variables:
#' \describe{
#'   \item{HS_6d}{6-digit HS Code}
#'   \item{HS_4d}{4-digit HS Code}
#'   \item{HS_2d}{2-digit HS Code}
#'   \item{NAICS_6d}{6-digit NAICS Code}
#'   \item{NAICS_4d}{4-digit NAICS Code}
#'   \item{NAICS_2d}{2-digit NAICS Code}
#' }
#' @source Pierce and Schott (2009, 2018),\url{https://spinup-000d1a-wp-offload-media.s3.amazonaws.com/faculty/wp-content/uploads/sites/47/2019/06/hssicnaics_20181015.zip}
"hs_naics"

#' HS0-NAICS Concordance
#'
#' A dataset containing concordances between HS0 and NAICS (combined) classification.
#'
#' @format A data frame with 8058 rows and 6 variables:
#' \describe{
#'   \item{HS0_6d}{6-digit HS0 Code}
#'   \item{HS0_4d}{4-digit HS0 Code}
#'   \item{HS0_2d}{2-digit HS0 Code}
#'   \item{NAICS_6d}{6-digit NAICS Code}
#'   \item{NAICS_4d}{4-digit NAICS Code}
#'   \item{NAICS_2d}{2-digit NAICS Code}
#' }
#' @source Pierce and Schott (2009, 2018),\url{https://spinup-000d1a-wp-offload-media.s3.amazonaws.com/faculty/wp-content/uploads/sites/47/2019/06/hssicnaics_20181015.zip}
"hs0_naics"

#' HS1-NAICS Concordance
#'
#' A dataset containing concordances between HS1 and NAICS (combined) classification.
#'
#' @format A data frame with 8297 rows and 6 variables:
#' \describe{
#'   \item{HS1_6d}{6-digit HS1 Code}
#'   \item{HS1_4d}{4-digit HS1 Code}
#'   \item{HS1_2d}{2-digit HS1 Code}
#'   \item{NAICS_6d}{6-digit NAICS Code}
#'   \item{NAICS_4d}{4-digit NAICS Code}
#'   \item{NAICS_2d}{2-digit NAICS Code}
#' }
#' @source Pierce and Schott (2009, 2018),\url{https://spinup-000d1a-wp-offload-media.s3.amazonaws.com/faculty/wp-content/uploads/sites/47/2019/06/hssicnaics_20181015.zip}
"hs1_naics"

#' HS2-NAICS Concordance
#'
#' A dataset containing concordances between HS2 and NAICS (combined) classification.
#'
#' @format A data frame with 8609 rows and 6 variables:
#' \describe{
#'   \item{HS2_6d}{6-digit HS2 Code}
#'   \item{HS2_4d}{4-digit HS2 Code}
#'   \item{HS2_2d}{2-digit HS2 Code}
#'   \item{NAICS_6d}{6-digit NAICS Code}
#'   \item{NAICS_4d}{4-digit NAICS Code}
#'   \item{NAICS_2d}{2-digit NAICS Code}
#' }
#' @source Pierce and Schott (2009, 2018),\url{https://spinup-000d1a-wp-offload-media.s3.amazonaws.com/faculty/wp-content/uploads/sites/47/2019/06/hssicnaics_20181015.zip}
"hs2_naics"

#' HS3-NAICS Concordance
#'
#' A dataset containing concordances between HS3 and NAICS (combined) classification.
#'
#' @format A data frame with 8545 rows and 6 variables:
#' \describe{
#'   \item{HS3_6d}{6-digit HS3 Code}
#'   \item{HS3_4d}{4-digit HS3 Code}
#'   \item{HS3_2d}{2-digit HS3 Code}
#'   \item{NAICS_6d}{6-digit NAICS Code}
#'   \item{NAICS_4d}{4-digit NAICS Code}
#'   \item{NAICS_2d}{2-digit NAICS Code}
#' }
#' @source Pierce and Schott (2009, 2018),\url{https://spinup-000d1a-wp-offload-media.s3.amazonaws.com/faculty/wp-content/uploads/sites/47/2019/06/hssicnaics_20181015.zip}
"hs3_naics"

#' HS4-NAICS Concordance
#'
#' A dataset containing concordances between HS4 and NAICS (combined) classification.
#'
#' @format A data frame with 8790 rows and 6 variables:
#' \describe{
#'   \item{HS4_6d}{6-digit HS4 Code}
#'   \item{HS4_4d}{4-digit HS4 Code}
#'   \item{HS4_2d}{2-digit HS4 Code}
#'   \item{NAICS_6d}{6-digit NAICS Code}
#'   \item{NAICS_4d}{4-digit NAICS Code}
#'   \item{NAICS_2d}{2-digit NAICS Code}
#' }
#' @source Pierce and Schott (2009, 2018),\url{https://spinup-000d1a-wp-offload-media.s3.amazonaws.com/faculty/wp-content/uploads/sites/47/2019/06/hssicnaics_20181015.zip}
"hs4_naics"

#' HS5-NAICS Concordance
#'
#' A dataset containing concordances between HS5 and NAICS (combined) classification.
#'
#' @format A data frame with 8973 rows and 6 variables:
#' \describe{
#'   \item{HS5_6d}{6-digit HS5 Code}
#'   \item{HS5_4d}{4-digit HS5 Code}
#'   \item{HS5_2d}{2-digit HS5 Code}
#'   \item{NAICS_6d}{6-digit NAICS Code}
#'   \item{NAICS_4d}{4-digit NAICS Code}
#'   \item{NAICS_2d}{2-digit NAICS Code}
#' }
#' @source Pierce and Schott (2009, 2018),\url{https://spinup-000d1a-wp-offload-media.s3.amazonaws.com/faculty/wp-content/uploads/sites/47/2019/06/hssicnaics_20181015.zip}
"hs5_naics"

#' SITC1-NAICS Concordance
#'
#' A dataset containing concordances between SITC1 and NAICS (combined) classification via HS (combined).
#'
#' @format A data frame with 3797 rows and 8 variables:
#' \describe{
#'   \item{SITC1_5d}{5-digit SITC1 Code}
#'   \item{SITC1_4d}{4-digit SITC1 Code}
#'   \item{SITC1_3d}{3-digit SITC1 Code}
#'   \item{SITC1_2d}{2-digit SITC1 Code}
#'   \item{SITC1_1d}{1-digit SITC1 Code}
#'   \item{NAICS_6d}{6-digit NAICS Code}
#'   \item{NAICS_4d}{4-digit NAICS Code}
#'   \item{NAICS_2d}{2-digit NAICS Code}
#' }
#' @source https://wits.worldbank.org/product_concordance.html; \url{https://unstats.un.org/unsd/trade/classifications/correspondence-tables.asp}; Pierce and Schott (2009, 2018),\url{https://spinup-000d1a-wp-offload-media.s3.amazonaws.com/faculty/wp-content/uploads/sites/47/2019/06/hssicnaics_20181015.zip}
"sitc1_naics"

#' SITC2-NAICS Concordance
#'
#' A dataset containing concordances between SITC2 and NAICS (combined) classification via HS (combined).
#'
#' @format A data frame with 5065 rows and 8 variables:
#' \describe{
#'   \item{SITC2_5d}{5-digit SITC2 Code}
#'   \item{SITC2_4d}{4-digit SITC2 Code}
#'   \item{SITC2_3d}{3-digit SITC2 Code}
#'   \item{SITC2_2d}{2-digit SITC2 Code}
#'   \item{SITC2_1d}{1-digit SITC2 Code}
#'   \item{NAICS_6d}{6-digit NAICS Code}
#'   \item{NAICS_4d}{4-digit NAICS Code}
#'   \item{NAICS_2d}{2-digit NAICS Code}
#' }
#' @source https://wits.worldbank.org/product_concordance.html; \url{https://unstats.un.org/unsd/trade/classifications/correspondence-tables.asp}; Pierce and Schott (2009, 2018),\url{https://spinup-000d1a-wp-offload-media.s3.amazonaws.com/faculty/wp-content/uploads/sites/47/2019/06/hssicnaics_20181015.zip}
"sitc2_naics"

#' SITC3-NAICS Concordance
#'
#' A dataset containing concordances between SITC3 and NAICS (combined) classification via HS (combined).
#'
#' @format A data frame with 6024 rows and 8 variables:
#' \describe{
#'   \item{SITC3_5d}{5-digit SITC3 Code}
#'   \item{SITC3_4d}{4-digit SITC3 Code}
#'   \item{SITC3_3d}{3-digit SITC3 Code}
#'   \item{SITC3_2d}{2-digit SITC3 Code}
#'   \item{SITC3_1d}{1-digit SITC3 Code}
#'   \item{NAICS_6d}{6-digit NAICS Code}
#'   \item{NAICS_4d}{4-digit NAICS Code}
#'   \item{NAICS_2d}{2-digit NAICS Code}
#' }
#' @source https://wits.worldbank.org/product_concordance.html; \url{https://unstats.un.org/unsd/trade/classifications/correspondence-tables.asp}; Pierce and Schott (2009, 2018),\url{https://spinup-000d1a-wp-offload-media.s3.amazonaws.com/faculty/wp-content/uploads/sites/47/2019/06/hssicnaics_20181015.zip}
"sitc3_naics"

#' SITC4-NAICS Concordance
#'
#' A dataset containing concordances between SITC4 and NAICS (combined) classification via HS (combined).
#'
#' @format A data frame with 5714 rows and 8 variables:
#' \describe{
#'   \item{SITC4_5d}{5-digit SITC4 Code}
#'   \item{SITC4_4d}{4-digit SITC4 Code}
#'   \item{SITC4_3d}{3-digit SITC4 Code}
#'   \item{SITC4_2d}{2-digit SITC4 Code}
#'   \item{SITC4_1d}{1-digit SITC4 Code}
#'   \item{NAICS_6d}{6-digit NAICS Code}
#'   \item{NAICS_4d}{4-digit NAICS Code}
#'   \item{NAICS_2d}{2-digit NAICS Code}
#' }
#' @source https://wits.worldbank.org/product_concordance.html; \url{https://unstats.un.org/unsd/trade/classifications/correspondence-tables.asp}; Pierce and Schott (2009, 2018),\url{https://spinup-000d1a-wp-offload-media.s3.amazonaws.com/faculty/wp-content/uploads/sites/47/2019/06/hssicnaics_20181015.zip}
"sitc4_naics"

#' SITC2-SITC1 Concordance
#'
#' A dataset containing concordances between SITC2 and SITC1 classification.
#'
#' @format A data frame with 1833 rows and 10 variables:
#' \describe{
#'   \item{SITC2_5d}{5-digit SITC2 Code}
#'   \item{SITC2_4d}{4-digit SITC2 Code}
#'   \item{SITC2_3d}{3-digit SITC2 Code}
#'   \item{SITC2_2d}{2-digit SITC2 Code}
#'   \item{SITC2_1d}{1-digit SITC2 Code}
#'   \item{SITC1_5d}{5-digit SITC1 Code}
#'   \item{SITC1_4d}{4-digit SITC1 Code}
#'   \item{SITC1_3d}{3-digit SITC1 Code}
#'   \item{SITC1_2d}{2-digit SITC1 Code}
#'   \item{SITC1_1d}{1-digit SITC1 Code}
#' }
#' @source \url{https://unstats.un.org/unsd/trade/classifications/correspondence-tables.asp}
"sitc2_sitc1"

#' SITC3-SITC1 Concordance
#'
#' A dataset containing concordances between SITC3 and SITC1 classification.
#'
#' @format A data frame with 3118 rows and 10 variables:
#' \describe{
#'   \item{SITC3_5d}{5-digit SITC3 Code}
#'   \item{SITC3_4d}{4-digit SITC3 Code}
#'   \item{SITC3_3d}{3-digit SITC3 Code}
#'   \item{SITC3_2d}{2-digit SITC3 Code}
#'   \item{SITC3_1d}{1-digit SITC3 Code}
#'   \item{SITC1_5d}{5-digit SITC1 Code}
#'   \item{SITC1_4d}{4-digit SITC1 Code}
#'   \item{SITC1_3d}{3-digit SITC1 Code}
#'   \item{SITC1_2d}{2-digit SITC1 Code}
#'   \item{SITC1_1d}{1-digit SITC1 Code}
#' }
#' @source \url{https://unstats.un.org/unsd/trade/classifications/correspondence-tables.asp}
"sitc3_sitc1"

#' SITC4-SITC1 Concordance
#'
#' A dataset containing concordances between SITC4 and SITC1 classification.
#'
#' @format A data frame with 3199 rows and 10 variables:
#' \describe{
#'   \item{SITC4_5d}{5-digit SITC4 Code}
#'   \item{SITC4_4d}{4-digit SITC4 Code}
#'   \item{SITC4_3d}{3-digit SITC4 Code}
#'   \item{SITC4_2d}{2-digit SITC4 Code}
#'   \item{SITC4_1d}{1-digit SITC4 Code}
#'   \item{SITC1_5d}{5-digit SITC1 Code}
#'   \item{SITC1_4d}{4-digit SITC1 Code}
#'   \item{SITC1_3d}{3-digit SITC1 Code}
#'   \item{SITC1_2d}{2-digit SITC1 Code}
#'   \item{SITC1_1d}{1-digit SITC1 Code}
#' }
#' @source \url{https://unstats.un.org/unsd/trade/classifications/correspondence-tables.asp}
"sitc4_sitc1"

#' SITC3-SITC2 Concordance
#'
#' A dataset containing concordances between SITC3 and SITC2 classification.
#'
#' @format A data frame with 3121 rows and 10 variables:
#' \describe{
#'   \item{SITC3_5d}{5-digit SITC3 Code}
#'   \item{SITC3_4d}{4-digit SITC3 Code}
#'   \item{SITC3_3d}{3-digit SITC3 Code}
#'   \item{SITC3_2d}{2-digit SITC3 Code}
#'   \item{SITC3_1d}{1-digit SITC3 Code}
#'   \item{SITC2_5d}{5-digit SITC2 Code}
#'   \item{SITC2_4d}{4-digit SITC2 Code}
#'   \item{SITC2_3d}{3-digit SITC2 Code}
#'   \item{SITC2_2d}{2-digit SITC2 Code}
#'   \item{SITC2_1d}{1-digit SITC2 Code}
#' }
#' @source \url{https://unstats.un.org/unsd/trade/classifications/correspondence-tables.asp}
"sitc3_sitc2"

#' SITC4-SITC2 Concordance
#'
#' A dataset containing concordances between SITC4 and SITC2 classification.
#'
#' @format A data frame with 3271 rows and 10 variables:
#' \describe{
#'   \item{SITC4_5d}{5-digit SITC4 Code}
#'   \item{SITC4_4d}{4-digit SITC4 Code}
#'   \item{SITC4_3d}{3-digit SITC4 Code}
#'   \item{SITC4_2d}{2-digit SITC4 Code}
#'   \item{SITC4_1d}{1-digit SITC4 Code}
#'   \item{SITC2_5d}{5-digit SITC2 Code}
#'   \item{SITC2_4d}{4-digit SITC2 Code}
#'   \item{SITC2_3d}{3-digit SITC2 Code}
#'   \item{SITC2_2d}{2-digit SITC2 Code}
#'   \item{SITC2_1d}{1-digit SITC2 Code}
#' }
#' @source \url{https://unstats.un.org/unsd/trade/classifications/correspondence-tables.asp}
"sitc4_sitc2"

#' A dataset containing concordances between SITC4 and SITC3 classification.
#'
#' @format A data frame with 3488 rows and 10 variables:
#' \describe{
#'   \item{SITC4_5d}{5-digit SITC4 Code}
#'   \item{SITC4_4d}{4-digit SITC4 Code}
#'   \item{SITC4_3d}{3-digit SITC4 Code}
#'   \item{SITC4_2d}{2-digit SITC4 Code}
#'   \item{SITC4_1d}{1-digit SITC4 Code}
#'   \item{SITC3_5d}{5-digit SITC3 Code}
#'   \item{SITC3_4d}{4-digit SITC3 Code}
#'   \item{SITC3_3d}{3-digit SITC3 Code}
#'   \item{SITC3_2d}{2-digit SITC3 Code}
#'   \item{SITC3_1d}{1-digit SITC3 Code}
#' }
#' @source \url{https://unstats.un.org/unsd/trade/sitcrev4.htm}
"sitc4_sitc3"

#' SITC2-Rauch Concordance
#'
#' A dataset containing concordances between SITC2 and Rauch's classification.
#'
#' @format A data frame with 1189 rows and 3 variables:
#' \describe{
#'   \item{SITC2}{SITC2 Code}
#'   \item{CON}{Conservative classification}
#'   \item{LIB}{Liberal classification}
#' }
#' @source Data from Jon Haveman's International Trade Data page: \url{http://www.macalester.edu/research/economics/PAGE/HAVEMAN/Trade.Resources/TradeData.html#Rauch}
"sitc2_rauch"

#' HS5-HS4 Concordance
#'
#' A dataset containing concordances between HS5 and HS4 classification.
#'
#' @format A data frame with 5388 rows and 6 variables:
#' \describe{
#'   \item{HS5_6d}{6-digit HS5 Code}
#'   \item{HS5_4d}{4-digit HS5 Code}
#'   \item{HS5_2d}{2-digit HS5 Code}
#'   \item{HS4_6d}{6-digit HS4 Code}
#'   \item{HS4_4d}{4-digit HS4 Code}
#'   \item{HS4_2d}{2-digit HS4 Code}
#' }
#' @source \url{https://unstats.un.org/unsd/trade/classifications/correspondence-tables.asp}
"hs5_hs4"

#' HS5-HS3 Concordance
#'
#' A dataset containing concordances between HS5 and HS3 classification.
#'
#' @format A data frame with 5388 rows and 6 variables:
#' \describe{
#'   \item{HS5_6d}{6-digit HS5 Code}
#'   \item{HS5_4d}{4-digit HS5 Code}
#'   \item{HS5_2d}{2-digit HS5 Code}
#'   \item{HS3_6d}{6-digit HS3 Code}
#'   \item{HS3_4d}{4-digit HS3 Code}
#'   \item{HS3_2d}{2-digit HS3 Code}
#' }
#' @source \url{https://unstats.un.org/unsd/trade/classifications/correspondence-tables.asp}
"hs5_hs3"

#' HS5-HS2 Concordance
#'
#' A dataset containing concordances between HS5 and HS2 classification.
#'
#' @format A data frame with 5388 rows and 6 variables:
#' \describe{
#'   \item{HS5_6d}{6-digit HS5 Code}
#'   \item{HS5_4d}{4-digit HS5 Code}
#'   \item{HS5_2d}{2-digit HS5 Code}
#'   \item{HS2_6d}{6-digit HS2 Code}
#'   \item{HS2_4d}{4-digit HS2 Code}
#'   \item{HS2_2d}{2-digit HS2 Code}
#' }
#' @source \url{https://unstats.un.org/unsd/trade/classifications/correspondence-tables.asp}
"hs5_hs2"

#' HS5-HS1 Concordance
#'
#' A dataset containing concordances between HS5 and HS1 classification.
#'
#' @format A data frame with 5388 rows and 6 variables:
#' \describe{
#'   \item{HS5_6d}{6-digit HS5 Code}
#'   \item{HS5_4d}{4-digit HS5 Code}
#'   \item{HS5_2d}{2-digit HS5 Code}
#'   \item{HS1_6d}{6-digit HS1 Code}
#'   \item{HS1_4d}{4-digit HS1 Code}
#'   \item{HS1_2d}{2-digit HS1 Code}
#' }
#' @source \url{https://unstats.un.org/unsd/trade/classifications/correspondence-tables.asp}
"hs5_hs1"

#' HS5-HS0 Concordance
#'
#' A dataset containing concordances between HS5 and HS0 classification.
#'
#' @format A data frame with 5388 rows and 6 variables:
#' \describe{
#'   \item{HS5_6d}{6-digit HS5 Code}
#'   \item{HS5_4d}{4-digit HS5 Code}
#'   \item{HS5_2d}{2-digit HS5 Code}
#'   \item{HS0_6d}{6-digit HS0 Code}
#'   \item{HS0_4d}{4-digit HS0 Code}
#'   \item{HS0_2d}{2-digit HS0 Code}
#' }
#' @source \url{https://unstats.un.org/unsd/trade/classifications/correspondence-tables.asp}
"hs5_hs0"

#' HS4-HS3 Concordance
#'
#' A dataset containing concordances between HS4 and HS3 classification.
#'
#' @format A data frame with 5205 rows and 6 variables:
#' \describe{
#'   \item{HS4_6d}{6-digit HS4 Code}
#'   \item{HS4_4d}{4-digit HS4 Code}
#'   \item{HS4_2d}{2-digit HS4 Code}
#'   \item{HS3_6d}{6-digit HS3 Code}
#'   \item{HS3_4d}{4-digit HS3 Code}
#'   \item{HS3_2d}{2-digit HS3 Code}
#' }
#' @source \url{https://unstats.un.org/unsd/trade/classifications/correspondence-tables.asp}
"hs4_hs3"

#' HS4-HS2 Concordance
#'
#' A dataset containing concordances between HS4 and HS2 classification.
#'
#' @format A data frame with 5206 rows and 6 variables:
#' \describe{
#'   \item{HS4_6d}{6-digit HS4 Code}
#'   \item{HS4_4d}{4-digit HS4 Code}
#'   \item{HS4_2d}{2-digit HS4 Code}
#'   \item{HS2_6d}{6-digit HS2 Code}
#'   \item{HS2_4d}{4-digit HS2 Code}
#'   \item{HS2_2d}{2-digit HS2 Code}
#' }
#' @source \url{https://unstats.un.org/unsd/trade/classifications/correspondence-tables.asp}
"hs4_hs2"

#' HS4-HS1 Concordance
#'
#' A dataset containing concordances between HS4 and HS1 classification.
#'
#' @format A data frame with 5206 rows and 6 variables:
#' \describe{
#'   \item{HS4_6d}{6-digit HS4 Code}
#'   \item{HS4_4d}{4-digit HS4 Code}
#'   \item{HS4_2d}{2-digit HS4 Code}
#'   \item{HS1_6d}{6-digit HS1 Code}
#'   \item{HS1_4d}{4-digit HS1 Code}
#'   \item{HS1_2d}{2-digit HS1 Code}
#' }
#' @source \url{https://unstats.un.org/unsd/trade/classifications/correspondence-tables.asp}
"hs4_hs1"

#' HS4-HS0 Concordance
#'
#' A dataset containing concordances between HS4 and HS0 classification.
#'
#' @format A data frame with 5206 rows and 6 variables:
#' \describe{
#'   \item{HS4_6d}{6-digit HS4 Code}
#'   \item{HS4_4d}{4-digit HS4 Code}
#'   \item{HS4_2d}{2-digit HS4 Code}
#'   \item{HS0_6d}{6-digit HS0 Code}
#'   \item{HS0_4d}{4-digit HS0 Code}
#'   \item{HS0_2d}{2-digit HS0 Code}
#' }
#' @source \url{https://unstats.un.org/unsd/trade/classifications/correspondence-tables.asp}
"hs4_hs0"

#' HS3-HS2 Concordance
#'
#' A dataset containing concordances between HS3 and HS2 classification.
#'
#' @format A data frame with 5052 rows and 6 variables:
#' \describe{
#'   \item{HS3_6d}{6-digit HS3 Code}
#'   \item{HS3_4d}{4-digit HS3 Code}
#'   \item{HS3_2d}{2-digit HS3 Code}
#'   \item{HS2_6d}{6-digit HS2 Code}
#'   \item{HS2_4d}{4-digit HS2 Code}
#'   \item{HS2_2d}{2-digit HS2 Code}
#' }
#' @source \url{https://unstats.un.org/unsd/trade/classifications/correspondence-tables.asp}
"hs3_hs2"

#' HS3-HS1 Concordance
#'
#' A dataset containing concordances between HS3 and HS1 classification.
#'
#' @format A data frame with 5052 rows and 6 variables:
#' \describe{
#'   \item{HS3_6d}{6-digit HS3 Code}
#'   \item{HS3_4d}{4-digit HS3 Code}
#'   \item{HS3_2d}{2-digit HS3 Code}
#'   \item{HS1_6d}{6-digit HS1 Code}
#'   \item{HS1_4d}{4-digit HS1 Code}
#'   \item{HS1_2d}{2-digit HS1 Code}
#' }
#' @source \url{https://unstats.un.org/unsd/trade/classifications/correspondence-tables.asp}
"hs3_hs1"

#' HS3-HS0 Concordance
#'
#' A dataset containing concordances between HS3 and HS0 classification.
#'
#' @format A data frame with 5053 rows and 6 variables:
#' \describe{
#'   \item{HS3_6d}{6-digit HS3 Code}
#'   \item{HS3_4d}{4-digit HS3 Code}
#'   \item{HS3_2d}{2-digit HS3 Code}
#'   \item{HS0_6d}{6-digit HS0 Code}
#'   \item{HS0_4d}{4-digit HS0 Code}
#'   \item{HS0_2d}{2-digit HS0 Code}
#' }
#' @source \url{https://unstats.un.org/unsd/trade/classifications/correspondence-tables.asp}
"hs3_hs0"

#' HS2-HS1 Concordance
#'
#' A dataset containing concordances between HS2 and HS1 classification.
#'
#' @format A data frame with 5223 rows and 6 variables:
#' \describe{
#'   \item{HS2_6d}{6-digit HS2 Code}
#'   \item{HS2_4d}{4-digit HS2 Code}
#'   \item{HS2_2d}{2-digit HS2 Code}
#'   \item{HS1_6d}{6-digit HS1 Code}
#'   \item{HS1_4d}{4-digit HS1 Code}
#'   \item{HS1_2d}{2-digit HS1 Code}
#' }
#' @source \url{https://unstats.un.org/unsd/trade/classifications/correspondence-tables.asp}
"hs2_hs1"

#' HS2-HS0 Concordance
#'
#' A dataset containing concordances between HS2 and HS0 classification.
#'
#' @format A data frame with 5223 rows and 6 variables:
#' \describe{
#'   \item{HS2_6d}{6-digit HS2 Code}
#'   \item{HS2_4d}{4-digit HS2 Code}
#'   \item{HS2_2d}{2-digit HS2 Code}
#'   \item{HS0_6d}{6-digit HS0 Code}
#'   \item{HS0_4d}{4-digit HS0 Code}
#'   \item{HS0_2d}{2-digit HS0 Code}
#' }
#' @source \url{https://unstats.un.org/unsd/trade/classifications/correspondence-tables.asp}
"hs2_hs0"

#' HS1-HS0 Concordance
#'
#' A dataset containing concordances between HS1 and HS0 classification.
#'
#' @format A data frame with 5130 rows and 6 variables:
#' \describe{
#'   \item{HS1_6d}{6-digit HS1 Code}
#'   \item{HS1_4d}{4-digit HS1 Code}
#'   \item{HS1_2d}{2-digit HS1 Code}
#'   \item{HS0_6d}{6-digit HS0 Code}
#'   \item{HS0_4d}{4-digit HS0 Code}
#'   \item{HS0_2d}{2-digit HS0 Code}
#' }
#' @source \url{https://unstats.un.org/unsd/trade/classifications/correspondence-tables.asp}
"hs1_hs0"

#' Sigma Table (3-Digit HS0)
#'
#' A dataset containing import demand elasticities by HS0 3-digit codes from Broda and Weinstein (QJE, 2006) for 73 countries.
#'
#' @format A data frame with 11293 rows and 4 variables:
#' \describe{
#'   \item{iso3c}{ISO 3-letter Country Code}
#'   \item{HS0_3d}{3-digit HS0 Code}
#'   \item{HS0_2d}{2-digit HS0 Code}
#'   \item{sigma}{Import Demand Elasticity}
#' }
#' @references C. Broda and D. Weinstein, "Globalization and the Gains from Variety," Quarterly Journal of Economics, Volume 121, Issue 2 - May 2006.
#' @source \url{http://www.columbia.edu/~dew35/TradeElasticities/TradeElasticities.html}
"sigma_hs0"

#' Sigma Table (5-Digit SITC3)
#'
#' A dataset containing import demand elasticities for the United States by 5-digit SITC3 codes from Broda and Weinstein (QJE, 2006).
#'
#' @format A data frame with 2716 rows and 7 variables:
#' \describe{
#'   \item{iso3c}{ISO 3-letter Country Code}
#'   \item{SITC3_5d}{5-digit SITC3 Code}
#'   \item{SITC3_4d}{4-digit SITC3 Code}
#'   \item{SITC3_3d}{3-digit SITC3 Code}
#'   \item{SITC3_2d}{2-digit SITC3 Code}
#'   \item{SITC3_1d}{1-digit SITC3 Code}
#'   \item{sigma}{Import Demand Elasticity}
#' }
#' @references C. Broda and D. Weinstein, "Globalization and the Gains from Variety," Quarterly Journal of Economics, Volume 121, Issue 2 - May 2006.
#' @source \url{http://www.columbia.edu/~dew35/TradeElasticities/TradeElasticities.html}
"sigma_sitc3"