% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pcmvtruncnorm.R
\name{pcmvtruncnorm}
\alias{pcmvtruncnorm}
\title{CDF for the Conditional Truncated Multivariate Normal}
\usage{
pcmvtruncnorm(
  lowerY,
  upperY,
  mean,
  sigma,
  lower,
  upper,
  dependent.ind,
  given.ind,
  X.given,
  ...
)
}
\arguments{
\item{lowerY}{the vector of lower limits for \strong{Y|X}. Passed to tmvtnorm::\code{\link[tmvtnorm]{ptmvnorm}}().}

\item{upperY}{the vector of upper limits for \strong{Y|X}. Must be greater than lowerY. Passed to tmvtnorm::\code{\link[tmvtnorm]{ptmvnorm}}().}

\item{mean}{the mean vector for Z of length of n}

\item{sigma}{the symmetric and positive-definite covariance matrix of dimension n x n of Z.}

\item{lower}{a vector of lower bounds of length n that truncate Z}

\item{upper}{a vector of upper bounds of length n that truncate Z}

\item{dependent.ind}{a vector of integers denoting the indices of dependent variable Y.}

\item{given.ind}{a vector of integers denoting the indices of conditioning variable X.  If specified as integer vector of length zero or left unspecified, the unconditional density is returned.}

\item{X.given}{a vector of reals denoting the conditioning value of X. This should be of the same length as \code{given.ind}}

\item{...}{Additional arguments passed to tmvtnorm::\code{\link[tmvtnorm]{ptmvnorm}}(). The CDF is calculated using the Genz algorithm based on these arguments: maxpts, abseps, and releps.}
}
\description{
Computes the distribution function for  a conditional truncated multivariate normal random variate \strong{Y|X}.
}
\details{
Calculates the probability that \strong{Y|X} is between \code{lowerY} and \code{upperY}. Z = (X, Y) is the fully joint multivariate normal distribution with mean equal mean and covariance matrix sigma, truncated between lower and upper.  See the vignette for more information.
}
\note{
For one-dimension conditionals \strong{Y|X}, this function uses the ptruncnorm() function in the truncnorm package. Otherwise, this function uses tmvtnorm::\code{\link[tmvtnorm]{ptmvnorm}}().
}
\examples{
# Example 1: Let X2,X3,X5|X2,X4 ~ N_3(1, Sigma)
# truncated between -10 and 10.
d <- 5
rho <- 0.9
Sigma <- matrix(0, nrow = d, ncol = d)
Sigma <- rho^abs(row(Sigma) - col(Sigma))

# Find P(-0.5 < X2,X3,X5 < 0 | X2,X4)
pcmvtruncnorm(rep(-0.5, 3), rep(0, 3),
  mean = rep(1, d),
  sigma = Sigma,
  lower = rep(-10, d),
  upper = rep(10, d),
  dependent.ind = c(2, 3, 5),
  given.ind = c(1, 4), X.given = c(1, -1)
)

# Example 2: Let X1| X2 = 1, X3 = -1, X4 = 1, X5 = -1 ~ N(1, Sigma) truncated
# between -10 and 10. Find P(-0.5 < X1 < 0 | X2 = 1, X3 = -1, X4 = 1, X5 = -1).
pcmvtruncnorm(-0.5, 0,
  mean = rep(1, d),
  sigma = Sigma,
  lower = rep(-10, d),
  upper = rep(10, d),
  dependent.ind = 1,
  given.ind = 2:5, X.given = c(1, -1, 1, -1)
)
}
