% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/condformat_render.R
\name{print.condformat_tbl}
\alias{print.condformat_tbl}
\title{Prints the data frame in an HTML page and shows it.}
\usage{
\method{print}{condformat_tbl}(x, ..., paginate = TRUE)
}
\arguments{
\item{x}{A \code{condformat_tbl} object}

\item{...}{
  Arguments passed on to \code{\link[htmltools:html_print]{htmltools::html_print}}
  \describe{
    \item{\code{background}}{Background color for web page}
    \item{\code{viewer}}{A function to be called with the URL or path to the generated
HTML page. Can be \code{NULL}, in which case no viewer will be invoked.}
  }}

\item{paginate}{A logical value. If \code{TRUE} the printing will be paginated}
}
\value{
the value returned by \code{\link[htmlTable:htmlTable]{htmlTable::htmlTable()}}
}
\description{
Prints the data frame in an HTML page and shows it.
}
\examples{
data(iris)
\dontrun{
print(condformat(iris[1:5,]))
}
}
