% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/04_longPutCondor.R
\name{longPutCondor}
\alias{longPutCondor}
\title{Calculates per share Profit and Loss (PnL) at expiration for Long Put Condor Option Strategy and draws its Bar Plot displaying PnL in the Plots tab.}
\usage{
longPutCondor(
  ST,
  X1L,
  X2Ml,
  X3Mu,
  X4H,
  P1L,
  P2Ml,
  P3Mu,
  P4H,
  hl = 0,
  hu = 2,
  spot = spot,
  pl = pl,
  myData = myData,
  myTibble = myTibble,
  PnL = PnL
)
}
\arguments{
\item{ST}{Spot Price at time T.}

\item{X1L}{Lower Strike Price or eXercise price for one ITM bought put.}

\item{X2Ml}{Middle-low Strike Price or eXercise price for middle strike sold put.}

\item{X3Mu}{Middle-upper Strike Price or eXercise price for middle strike sold put.}

\item{X4H}{Higher Strike Price or eXercise price for one OTM bought put.}

\item{P1L}{Put Premium or Put Price paid for the one OTM bought Put.}

\item{P2Ml}{Put Premium or Put Price received from the middle-low sold Put.}

\item{P3Mu}{Put Premium or Put Price received from the middle-upper sold Put.}

\item{P4H}{Put Premium or Put Price paid for the one ITM bought Put.}

\item{hl}{lower bound value for setting lower-limit of x-axis displaying spot price.}

\item{hu}{upper bound value for setting upper-limit of x-axis displaying spot price.}

\item{spot}{Spot Price}

\item{pl}{Profit and Loss}

\item{myData}{Data frame}

\item{myTibble}{tibble}

\item{PnL}{Profit and Loss}
}
\value{
graph of the strategy
}
\description{
This strategy consists of a long position in an OTM Put option with a strike price X1L, a short position in an OTM Put option with a higher strike price X2Ml, a short position in an ITM Put option with a strike price X3Mu, and a long position in an ITM Put option with a higher strike price X4H. All strikes are equidistant: X4H minus X3Mu equals to X3Mu minus X2Ml; equals to X2Mu minus X1L(Kakushadze & Serur, 2018).
}
\details{
According to conceptual details given by Cohen (2015), and a closed form solution provided by Kakushadze and Serur (2018), this method is developed, and the given examples are created, to compute per share Profit and Loss at expiration for Long Put Condor Option Strategy and draw its graph in the Plots tab.
}
\examples{
longPutCondor(425,400,420,440,460,16,22.50,35.50,50,hl=0.9,hu=1.125)
}
\references{
Cohen, G. (2015). The Bible of Options Strategies (2nd ed.). Pearson Technology Group.\cr
Kakushadze, Z., & Serur, J. A. (2018, August 17). 151 Trading Strategies. Palgrave Macmillan. https://papers.ssrn.com/sol3/papers.cfm?abstract_id=3247865 \cr
R Graphics Cookbook. (n.d.). Coloring Negative and Positive Bars Differently. https://r-graphics.org/recipe-bar-graph-color-neg \cr
Gross C, Ottolinger P (2016).\emph{ggThemeAssist: Add-in to Customize 'ggplot2' Themes}. R package version 0.1.5, <URL: https://CRAN.R-project.org/package=ggThemeAssist>.
}
\author{
MaheshP Kumar, \email{maheshparamjitkumar@gmail.com}
}
