% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/conductor.R
\name{Conductor}
\alias{Conductor}
\title{Create a "conductor" tour}
\description{
In addition to this page, you can also directly access the documentation
of shepherd.js here: \url{https://shepherdjs.dev/docs/index.html}.
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-Conductor-new}{\code{Conductor$new()}}
\item \href{#method-Conductor-init}{\code{Conductor$init()}}
\item \href{#method-Conductor-start}{\code{Conductor$start()}}
\item \href{#method-Conductor-step}{\code{Conductor$step()}}
\item \href{#method-Conductor-updateStepOptions}{\code{Conductor$updateStepOptions()}}
\item \href{#method-Conductor-show}{\code{Conductor$show()}}
\item \href{#method-Conductor-remove}{\code{Conductor$remove()}}
\item \href{#method-Conductor-moveNext}{\code{Conductor$moveNext()}}
\item \href{#method-Conductor-moveBack}{\code{Conductor$moveBack()}}
\item \href{#method-Conductor-cancel}{\code{Conductor$cancel()}}
\item \href{#method-Conductor-complete}{\code{Conductor$complete()}}
\item \href{#method-Conductor-hide}{\code{Conductor$hide()}}
\item \href{#method-Conductor-getCurrentStep}{\code{Conductor$getCurrentStep()}}
\item \href{#method-Conductor-getHighlightedElement}{\code{Conductor$getHighlightedElement()}}
\item \href{#method-Conductor-isOpen}{\code{Conductor$isOpen()}}
\item \href{#method-Conductor-isActive}{\code{Conductor$isActive()}}
\item \href{#method-Conductor-clone}{\code{Conductor$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Conductor-new"></a>}}
\if{latex}{\out{\hypertarget{method-Conductor-new}{}}}
\subsection{Method \code{new()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Conductor$new(
  exitOnEsc = TRUE,
  keyboardNavigation = TRUE,
  useModalOverlay = TRUE,
  classPrefix = NULL,
  tourName = NULL,
  stepsContainer = NULL,
  modalContainer = NULL,
  confirmCancel = FALSE,
  confirmCancelMessage = NULL,
  defaultStepOptions = NULL,
  mathjax = FALSE,
  progress = FALSE,
  onComplete = NULL,
  onCancel = NULL,
  onHide = NULL,
  onShow = NULL,
  onStart = NULL,
  onActive = NULL,
  onInactive = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{exitOnEsc}}{Allow closing the tour by pressing "Escape". Default is
\code{TRUE}.}

\item{\code{keyboardNavigation}}{Allow navigating the tour with keyboard arrows.
Default is \code{TRUE}.}

\item{\code{useModalOverlay}}{Highlight the tour popover and the element (if
specified). Default is \code{TRUE}.}

\item{\code{classPrefix}}{Add a prefix to the classes of the tour. This allows
having different CSS for each tour.}

\item{\code{tourName}}{An (optional) name to give to the tour.}

\item{\code{stepsContainer}}{An optional container element for the steps. If \code{NULL}
(default), the steps will be appended to \code{document.body}.}

\item{\code{modalContainer}}{An optional container element for the modal. If \code{NULL}
(default), the modal will be appended to \code{document.body}.}

\item{\code{confirmCancel}}{Ask confirmation to cancel the tour. Default is
\code{FALSE}.}

\item{\code{confirmCancelMessage}}{Message in the popup that ask confirmation to
close the tour (works only if \code{confirmCancel = TRUE}).}

\item{\code{defaultStepOptions}}{A nested list of options to apply to the entire
tour. See \code{Details}.}

\item{\code{mathjax}}{Enable MathJax? Default is \code{FALSE}. This requires importing
MathJax, for example with \code{shiny::withMathJax()}.}

\item{\code{progress}}{Show a step counter in each step? Default is \code{FALSE}.}

\item{\code{onComplete}}{A JavaScript code to run when the tour is completed.}

\item{\code{onCancel}}{A JavaScript code to run when the tour is cancelled.}

\item{\code{onHide}}{A JavaScript code to run when the tour is hidden.}

\item{\code{onShow}}{A JavaScript code to run when the tour is shown.}

\item{\code{onStart}}{A JavaScript code to run when the tour starts.}

\item{\code{onActive}}{A JavaScript code to run when the tour is active.}

\item{\code{onInactive}}{A JavaScript code to run when the tour is inactive.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Create a new \code{Conductor} object.
}

\subsection{Returns}{
A \code{Conductor} object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Conductor-init"></a>}}
\if{latex}{\out{\hypertarget{method-Conductor-init}{}}}
\subsection{Method \code{init()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Conductor$init(session = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{session}}{A valid Shiny session. If \code{NULL} (default), the function
attempts to get the session with \code{shiny::getDefaultReactiveDomain()}.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Initialise \code{Conductor}.
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Conductor-start"></a>}}
\if{latex}{\out{\hypertarget{method-Conductor-start}{}}}
\subsection{Method \code{start()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Conductor$start(session = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{session}}{A valid Shiny session. If \code{NULL} (default), the function
attempts to get the session with \code{shiny::getDefaultReactiveDomain()}.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Start \code{Conductor}.
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Conductor-step"></a>}}
\if{latex}{\out{\hypertarget{method-Conductor-step}{}}}
\subsection{Method \code{step()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Conductor$step(
  title = NULL,
  text = NULL,
  el = NULL,
  position = NULL,
  arrow = TRUE,
  tabId = NULL,
  tab = NULL,
  canClickTarget = TRUE,
  advanceOn = NULL,
  scrollTo = NULL,
  cancelIcon = NULL,
  showOn = NULL,
  id = NULL,
  buttons = NULL,
  classes = NULL,
  highlightClass = NULL,
  onComplete = NULL,
  onCancel = NULL,
  onHide = NULL,
  onShow = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{title}}{Title of the popover.}

\item{\code{text}}{Text of the popover.}

\item{\code{el}}{The element to highlight. It can be an id (for example \verb{#mynav}),
a class (for instance \code{.navbar}), or a general tag (for example \code{button}).
If \code{NULL} (default) or if the selector is not found, the popover will appear
in the center of the page.}

\item{\code{position}}{Position of the popover relative to the element. Possible
values are: 'auto', 'auto-start', 'auto-end', 'top', 'top-start', 'top-end',
'bottom', 'bottom-start', 'bottom-end', 'right', 'right-start', 'right-end',
'left', 'left-start', 'left-end'.}

\item{\code{arrow}}{Add an arrow pointing towards the highlighted element. Default
is \code{TRUE}.}

\item{\code{tabId}}{Id of the \code{tabsetPanel()}.}

\item{\code{tab}}{Name of the tab that contains the element.}

\item{\code{canClickTarget}}{Allow the highlighted element to be clicked. Default
is \code{TRUE}.}

\item{\code{advanceOn}}{An action on the page which should advance the tour to
the next step. It should be a list with a string selector and an event
name.}

\item{\code{scrollTo}}{Should the element be scrolled to when this step is shown?
Default is \code{TRUE}.}

\item{\code{cancelIcon}}{A list of two elements: \code{enabled} is a boolean indicating
whether a "close" icon should be displayed (default is \code{TRUE}); \code{label} is
the label to add for \code{aria-label}.}

\item{\code{showOn}}{Either a boolean or a JavaScript expression that returns \code{true}
or \code{false}. It indicates whether the step should be displayed in the tour.}

\item{\code{id}}{Name of the step (optional).}

\item{\code{buttons}}{A list of lists. Each "sublist" contains the information
for one button. There are six possible arguments for each button: action
("back" or "next"), text (name of the button), secondary (\code{TRUE}/\code{FALSE}),
disabled (\code{TRUE}/\code{FALSE}), label (aria-label of the button), and classes
(for finer CSS customization).}

\item{\code{classes}}{A character vector of extra classes to add to the step's
content element.}

\item{\code{highlightClass}}{An extra class to apply to \code{el} when it is highlighted.
Only one extra class is accepted.}

\item{\code{onComplete}}{Some JavaScript code to run when the step is complete
(only for the last step).}

\item{\code{onCancel}}{Some JavaScript code to run when the step is cancelled.}

\item{\code{onHide}}{Some JavaScript code to run when the step is hidden.}

\item{\code{onShow}}{Some JavaScript code to run when the step is shown.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Add a step in a \code{Conductor} tour.
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Conductor-updateStepOptions"></a>}}
\if{latex}{\out{\hypertarget{method-Conductor-updateStepOptions}{}}}
\subsection{Method \code{updateStepOptions()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Conductor$updateStepOptions(
  step = NULL,
  title = NULL,
  text = NULL,
  el = NULL,
  position = NULL,
  arrow = TRUE,
  tabId = NULL,
  tab = NULL,
  canClickTarget = TRUE,
  advanceOn = NULL,
  scrollTo = TRUE,
  cancelIcon = NULL,
  showOn = NULL,
  id = NULL,
  buttons = NULL,
  classes = NULL,
  highlightClass = NULL,
  session = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{step}}{Id of the step (optional). If \code{NULL} (default), the current
step is used.}

\item{\code{title}}{Title of the popover.}

\item{\code{text}}{Text of the popover.}

\item{\code{el}}{The element to highlight. It can be an id (for example \verb{#mynav}),
a class (for instance \code{.navbar}), or a general tag (for example \code{button}).
If \code{NULL} (default) or if the selector is not found, the popover will appear
in the center of the page.}

\item{\code{position}}{Position of the popover relative to the element. Possible
values are: 'auto', 'auto-start', 'auto-end', 'top', 'top-start', 'top-end',
'bottom', 'bottom-start', 'bottom-end', 'right', 'right-start', 'right-end',
'left', 'left-start', 'left-end'.}

\item{\code{arrow}}{Add an arrow pointing towards the highlighted element. Default
is \code{TRUE}.}

\item{\code{tabId}}{Id of the \code{tabsetPanel()}.}

\item{\code{tab}}{Name of the tab that contains the element.}

\item{\code{canClickTarget}}{Allow the highlighted element to be clicked. Default
is \code{TRUE}.}

\item{\code{advanceOn}}{An action on the page which should advance shepherd to the
next step. It should be a list with a string selector and an event name.}

\item{\code{scrollTo}}{Should the element be scrolled to when this step is shown?
Default is \code{TRUE}.}

\item{\code{cancelIcon}}{A list of two elements: \code{enabled} is a boolean indicating
whether a "close" icon should be displayed (default is \code{TRUE}); \code{label} is
the label to add for \code{aria-label}.}

\item{\code{showOn}}{Either a boolean or a JavaScript expression that returns \code{true}
or \code{false}. It indicates whether the step should be displayed in the tour.}

\item{\code{id}}{Name of the step (optional).}

\item{\code{buttons}}{A list of lists. Each "sublist" contains the information
for one button. There are six possible arguments for each button: action
("back" or "next"), text (name of the button), secondary (\code{TRUE}/\code{FALSE}),
disabled (\code{TRUE}/\code{FALSE}), label (aria-label of the button), and classes
(for finer CSS customization).}

\item{\code{classes}}{A character vector of extra classes to add to the step's
content element.}

\item{\code{highlightClass}}{An extra class to apply to \code{el} when it is highlighted.
Only one extra class is accepted.}

\item{\code{session}}{A valid Shiny session. If \code{NULL} (default), the function
attempts to get the session with \code{shiny::getDefaultReactiveDomain()}.}

\item{\code{onShow}}{Some JavaScript code to run when the step is shown.}

\item{\code{onHide}}{Some JavaScript code to run when the step is hidden.}

\item{\code{onCancel}}{Some JavaScript code to run when the step is cancelled.}

\item{\code{onComplete}}{Some JavaScript code to run when the step is complete
(only for the last step).}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Modify the options of a specific step.
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Conductor-show"></a>}}
\if{latex}{\out{\hypertarget{method-Conductor-show}{}}}
\subsection{Method \code{show()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Conductor$show(step = NULL, session = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{step}}{Either the id of the step to show (defined in \verb{$step()}) or
its number.}

\item{\code{session}}{A valid Shiny session. If \code{NULL} (default), the function
attempts to get the session with \code{shiny::getDefaultReactiveDomain()}.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Show a specific step.
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Conductor-remove"></a>}}
\if{latex}{\out{\hypertarget{method-Conductor-remove}{}}}
\subsection{Method \code{remove()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Conductor$remove(step = NULL, session = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{step}}{A character vector with the id(s) of the step(s) to remove
(defined in \verb{$step()}).}

\item{\code{session}}{A valid Shiny session. If \code{NULL} (default), the function
attempts to get the session with \code{shiny::getDefaultReactiveDomain()}.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Remove specific step(s).
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Conductor-moveNext"></a>}}
\if{latex}{\out{\hypertarget{method-Conductor-moveNext}{}}}
\subsection{Method \code{moveNext()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Conductor$moveNext(session = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{session}}{A valid Shiny session. If \code{NULL} (default), the function
attempts to get the session with \code{shiny::getDefaultReactiveDomain()}.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Advances the tour to the next step.
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Conductor-moveBack"></a>}}
\if{latex}{\out{\hypertarget{method-Conductor-moveBack}{}}}
\subsection{Method \code{moveBack()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Conductor$moveBack(session = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{session}}{A valid Shiny session. If \code{NULL} (default), the function
attempts to get the session with \code{shiny::getDefaultReactiveDomain()}.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Shows the previous step.
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Conductor-cancel"></a>}}
\if{latex}{\out{\hypertarget{method-Conductor-cancel}{}}}
\subsection{Method \code{cancel()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Conductor$cancel(session = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{session}}{A valid Shiny session. If \code{NULL} (default), the function
attempts to get the session with \code{shiny::getDefaultReactiveDomain()}.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Cancels the tour.
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Conductor-complete"></a>}}
\if{latex}{\out{\hypertarget{method-Conductor-complete}{}}}
\subsection{Method \code{complete()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Conductor$complete(session = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{session}}{A valid Shiny session. If \code{NULL} (default), the function
attempts to get the session with \code{shiny::getDefaultReactiveDomain()}.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Completes the tour.
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Conductor-hide"></a>}}
\if{latex}{\out{\hypertarget{method-Conductor-hide}{}}}
\subsection{Method \code{hide()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Conductor$hide(session = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{session}}{A valid Shiny session. If \code{NULL} (default), the function
attempts to get the session with \code{shiny::getDefaultReactiveDomain()}.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Hides the current step.
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Conductor-getCurrentStep"></a>}}
\if{latex}{\out{\hypertarget{method-Conductor-getCurrentStep}{}}}
\subsection{Method \code{getCurrentStep()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Conductor$getCurrentStep(session = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{session}}{A valid Shiny session. If \code{NULL} (default), the function
attempts to get the session with \code{shiny::getDefaultReactiveDomain()}.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Get the id of the current step. If no \code{id} was specified in \verb{$step()},
a random id is generated.
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Conductor-getHighlightedElement"></a>}}
\if{latex}{\out{\hypertarget{method-Conductor-getHighlightedElement}{}}}
\subsection{Method \code{getHighlightedElement()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Conductor$getHighlightedElement(session = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{session}}{A valid Shiny session. If \code{NULL} (default), the function
attempts to get the session with \code{shiny::getDefaultReactiveDomain()}.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Returns the id of the highlighted element of the current step. If this
element has no id, it returns its class.
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Conductor-isOpen"></a>}}
\if{latex}{\out{\hypertarget{method-Conductor-isOpen}{}}}
\subsection{Method \code{isOpen()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Conductor$isOpen(step = NULL, session = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{step}}{Id of the step (optional). If \code{NULL} (default), the current
step is used.}

\item{\code{session}}{A valid Shiny session. If \code{NULL} (default), the function
attempts to get the session with \code{shiny::getDefaultReactiveDomain()}.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Returns a value \code{TRUE} or \code{FALSE} indicating whether the step is open.
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Conductor-isActive"></a>}}
\if{latex}{\out{\hypertarget{method-Conductor-isActive}{}}}
\subsection{Method \code{isActive()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Conductor$isActive(session = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{session}}{A valid Shiny session. If \code{NULL} (default), the function
attempts to get the session with \code{shiny::getDefaultReactiveDomain()}.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Returns a value \code{TRUE} or \code{FALSE} indicating whether the tour is active.
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Conductor-clone"></a>}}
\if{latex}{\out{\hypertarget{method-Conductor-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Conductor$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
