% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/confinterpret.R
\name{confinterpret}
\alias{confinterpret}
\title{Descriptive interpretations of confidence intervals.}
\usage{
confinterpret(ci, interpretation_set, boundaries, comparison_labels = NULL,
  low_to_high = TRUE)
}
\arguments{
\item{ci}{A single row from a matrix of the type returned by \code{confint()},
containing the confidence interval for the parameter estimate. The two
columns provide the lower and upper confidence limits.}

\item{interpretation_set}{List-based object that specifies the boundaries between regions that each
of the confidence limits can fall in, and the interpretations to be
returned in each of the cases.}

\item{boundaries}{Vector of numbers specifying the values for each of the boundaries defined
in the \code{interpretation_set}. Normally provided in low-to-high order, but
see the \code{low_to_high} parameter for options.}

\item{comparison_labels}{Character vector specifying the labels to be used within the
interpretation to describe the comparison. Required if the
\code{interpretation_set} includes a $placeholders entry. Null otherwise.}

\item{low_to_high}{Are the boundaries ordered low-to-high (TRUE) or high-to-low (FALSE)?
This can be used to reverse the assessment, including in the cases where
only one boundary is supplied. See Details.}
}
\value{
A list object of class \code{\link{interpretation_result}} with
  elements stating the interpretation in different formats, plus the
  parameters used to generate the interpretation.
}
\description{
Produces descriptive interpretations of confidence intervals, depending
on the type of test specified by an \code{\link{interpretation_set}}.
}
\details{
Helpful wrapper functions are provided for some commonly used types of
test:

\describe{
  \item{Superiority tests}{\code{\link{interpret_superiority}}}
  \item{Non-inferiority tests}{\code{\link{interpret_noninferiority}}}
  \item{Equivalence tests}{\code{\link{interpret_equivalence}}}
}

The low_to_high parameter can be set to FALSE to facilitate the situation
where the boundaries are ordered high-to-low. This enables the same
\code{interpretation_set} object to be used for both beneficial and harmful
outcomes. For an \code{interpretation_set} that has been defined as if
higher numbers are better (for example, proportion of participants
recovering from a particular illness after treatment) then the inferiority
interpretations will be listed first and the superiority ones last. To use
this with a negative outcome (for example, proportion of participants
catching an illness after a preventative measure), provide the boundaries
in high-to-low order and use \code{low_to_high = FALSE}. This will also
work where a single boundary is specified, and will act to 'reverse' the
interpretations.

The use of low_to_high only affects the order of the boundaries (and
the regions these implicitly define). It does \strong{not} affect the
ordering of the confidence interval: the numerically lower confidence limit
should be listed first either way.

Plotting functions are provided to display the results of
\code{confinterpret}. To plot a single result see
\code{\link{plot.interpretation_result}}. To plot multiple results on one
chart see \code{\link{plot_interpretation_result_list}}.
}
\examples{
# Establish a test confidence interval
ci_test <- matrix(c(-0.1,0.1),
                  nrow = 1, dimnames = list("estimate",
                                            c("2.5 \%","97.5 \%")))
confinterpret(ci_test, interpretations_superiority, 0,
  comparison_labels = c(comparison_intervention = "Treatment as usual",
                        tested_intervention = "New treatment"))

}
