% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/integrations.R
\name{update_integration}
\alias{update_integration}
\title{Update an OAuth integration}
\usage{
update_integration(
  integration,
  name = NULL,
  description = NULL,
  template = NULL,
  config = NULL
)
}
\arguments{
\item{integration}{A \code{connect_integration} object (as returned by \code{\link[=get_integrations]{get_integrations()}},
\code{\link[=get_integration]{get_integration()}}, or \code{\link[=create_integration]{create_integration()}}).}

\item{name}{A new name for the integration.}

\item{description}{A new description for the integration.}

\item{template}{The template to use (generally not changed after creation).}

\item{config}{A list with updated OAuth integration configuration. If \code{NULL}
(default), the configuration remains unchanged. You can update individual
configuration fields without affecting others.}
}
\value{
A \code{connect_integration} object representing the updated OAuth
integration. See \code{\link[=get_integration]{get_integration()}} for details on the returned object.
}
\description{
Updates an existing OAuth integration. All fields except \code{integration} are optional,
and are unchanged if not provided.

You must have administrator privileges to perform this action.

See the Posit Connect documentation on
\href{https://docs.posit.co/connect/admin/integrations/oauth-integrations/}{OAuth integrations} for
more information.
}
\examples{
\dontrun{
client <- connect()

# Get an existing integration
integration <- get_integration(client, "your-integration-guid")

# Update the integration's name and description
updated_integration <- update_integration(
  integration,
  name = "Updated GitHub Integration",
  description = "A more descriptive description."
)

# Update only the client secret in the configuration
updated_integration <- update_integration(
  integration,
  config = list(
    client_secret = "your-new-client-secret"
  )
)
}

}
\seealso{
\code{\link[=get_integrations]{get_integrations()}}, \code{\link[=get_integration]{get_integration()}}, \code{\link[=create_integration]{create_integration()}},
\code{\link[=delete_integration]{delete_integration()}}

Other oauth integration functions: 
\code{\link{create_integration}()},
\code{\link{delete_integration}()},
\code{\link{get_associations}()},
\code{\link{get_integration}()},
\code{\link{get_integrations}()},
\code{\link{set_integrations}()}
}
\concept{oauth integration functions}
