% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Exact_unconditional_test_2x2.R
\name{Exact_unconditional_test_2x2}
\alias{Exact_unconditional_test_2x2}
\title{Exact unconditional test for association in 2x2 tables}
\usage{
Exact_unconditional_test_2x2(n, statistic = "Pearson", gamma = 1e-04)
}
\arguments{
\item{n}{the observed counts (a 2x2 matrix)}

\item{statistic}{'Pearson' (Suissa-Shuster test default), 'LR' (likelihood ratio),
' unpooled' (unpooled Z), or 'Fisher' (Fisher-Boschloo test)}

\item{gamma}{parameter for the Berger and Boos procedure (default=0.0001 gamma=0: no adj)}
}
\value{
An object of the \link{contingencytables_result} class,
basically a subclass of \code{\link[base:list]{base::list()}}. Use the \code{\link[utils:str]{utils::str()}} function
to see the specific elements returned.
}
\description{
Exact unconditional test for association in 2x2 tables

Described in Chapter 4 "The 2x2 Table"
}
\note{
Somewhat crude code with maximization over a simple partition of the
nuisance parameter space into 'num_pi_values' equally spaced values
(1000, hardcoded).
This method could be improved with a better algorithm for the
maximization however, it works well for most purposes. \code{plot()} the results
to get an indication of the precision. A refinement of the maximization
can be done with a manual restriction of the parameter space.
}
\section{Table orientation}{
 In most study designs, rows designate a grouping of the data, for
instance, into treatment or exposure groups, while the columns indicate a
dichotomous outcome, usually with the first column representing the outcome
of interest. This designation of rows and columns may not be relevant in all
study designs, please see the introduction to chapter 4 for details.
}

\examples{
Exact_unconditional_test_2x2(tea)
Exact_unconditional_test_2x2(perondi_2004)
Exact_unconditional_test_2x2(lampasona_2013)
Exact_unconditional_test_2x2(ritland_2007)
}
