% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/contrast.lm.R
\name{contrast.lm}
\alias{contrast.lm}
\alias{contrast.gls}
\alias{contrast.lme}
\alias{contrast.geese}
\alias{contrast_calc}
\title{General Contrasts of Regression Coefficients}
\usage{
\method{contrast}{lm}(fit, ...)

\method{contrast}{gls}(fit, ...)

\method{contrast}{lme}(fit, ...)

\method{contrast}{geese}(fit, ...)

contrast_calc(
  fit,
  a,
  b,
  cnames = NULL,
  type = c("individual", "average"),
  weights = "equal",
  conf.int = 0.95,
  fcType = "simple",
  fcFunc = I,
  covType = NULL,
  ...,
  env = parent.frame(2)
)
}
\arguments{
\item{fit}{A fit of class \code{lm}, \code{glm}, etc.}

\item{...}{For \code{contrast()}, these pass arguments to \code{contrast_calc()}. For
\code{contrast_calc()}, they are not used.}

\item{a, b}{Lists containing conditions for all predictors in the model that
will be contrasted to form the hypothesis \code{H0: a = b}. The \code{gendata}
function will generate the necessary combinations and default values for
unspecified predictors. See examples below.}

\item{cnames}{A vector of character strings naming the contrasts when
\code{type = "individual"}.  Usually \code{cnames} is not necessary as
the function tries to name the contrasts by examining which
predictors are varying consistently in the two lists.  \code{cnames} will be
needed when you contrast "non-comparable" settings, e.g., you compare
\code{list(treat = "drug", age = c(20,30))} with
\verb{list(treat = "placebo", age = c(40,50)}.}

\item{type}{A character string. Set \code{type="average"} to average the
individual contrasts (e.g., to obtain a "Type II" or "Type III" contrast).}

\item{weights}{A numeric vector, used when \code{type = "average"}, to
obtain weighted contrasts.}

\item{conf.int}{The confidence level for confidence intervals for the
contrasts.}

\item{fcType}{A character string: "simple", "log" or "signed".}

\item{fcFunc}{A function to transform the numerator and denominator
of fold changes.}

\item{covType}{A string matching the method for estimating the covariance
matrix. The default value produces the typical estimate. See
\code{\link[sandwich:vcovHC]{sandwich::vcovHC()}} for options.}

\item{env}{An environment in which evaluate fit.}
}
\value{
a list of class \code{contrast.Design} containing the elements
\code{Contrast}, \code{SE}, \code{Z}, \code{var}, \code{df.residual} \code{Lower}, \code{Upper}, \code{Pvalue}, \code{X},
\code{cnames}, and \code{foldChange}, which denote the contrast estimates, standard
errors, Z or t-statistics, variance matrix, residual degrees of freedom
(this is \code{NULL} if the model was not \code{ols}), lower and upper confidence
limits, 2-sided P-value, design matrix, and contrast names (or \code{NULL}).
}
\description{
This function computes one or more contrasts of the estimated regression
coefficients in a fit from one of the functions in Design, along with
standard errors, confidence limits, t or Z statistics, P-values.
}
\details{
These functions mirror \code{\link[rms:contrast]{rms::contrast.rms()}} but have fewer options.

There are some between-package inconsistencies regarding degrees of freedom
in some models. See the package vignette for more details.

Fold changes are calculated for each hypothesis. When \code{fcType ="simple"}, the
ratio of the \code{a} group predictions over the \code{b}
group predictions are used. When \code{fcType = "signed"}, the ratio is used
if it is greater than 1; otherwise the negative inverse (e.g.,
\code{-1/ratio}) is returned.
}
\examples{

library(nlme)
Orthodont2 <- Orthodont
Orthodont2$newAge <- Orthodont$age - 11
fm1Orth.lme2 <- lme(distance ~ Sex * newAge,
    data = Orthodont2,
    random = ~ newAge | Subject
)
summary(fm1Orth.lme2)

contrast(fm1Orth.lme2,
    a = list(Sex = levels(Orthodont2$Sex), newAge = 8 - 11),
    b = list(Sex = levels(Orthodont2$Sex), newAge = 10 - 11)
)

# ---------------------------------------------------------------------------

anova_model <- lm(expression ~ diet * group, data = two_factor_crossed)
anova(anova_model)

library(ggplot2)
theme_set(theme_bw() + theme(legend.position = "top"))
ggplot(two_factor_crossed) +
    aes(x = diet, y = expression, col = group, shape = group) +
    geom_point() +
    geom_smooth(aes(group = group), method = lm, se = FALSE)

int_model <- lm(expression ~ diet * group, data = two_factor_crossed)
main_effects <- lm(expression ~ diet + group, data = two_factor_crossed)

# Interaction effect is probably real:
anova(main_effects, int_model)

# Test treatment in low fat diet:
veh_group <- list(diet = "low fat", group = "vehicle")
trt_group <- list(diet = "low fat", group = "treatment")
contrast(int_model, veh_group, trt_group)

# ---------------------------------------------------------------------------

car_mod <- lm(mpg ~ am + wt, data = mtcars)
print(summary(car_mod), digits = 5)

mean_wt <- mean(mtcars$wt)

manual_trans <- list(am = 0, wt = mean_wt)
auto_trans <- list(am = 1, wt = mean_wt)
print(contrast(car_mod, manual_trans, auto_trans), digits = 5)
}
\seealso{
\code{\link[rms:contrast]{rms::contrast.rms()}}, \code{\link[sandwich:vcovHC]{sandwich::vcovHC()}}
}
\keyword{models}
\keyword{regression}
