% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gensig.R
\name{gensig}
\alias{gensig}
\title{Generate periodic signal}
\usage{
gensig(signal, tau, tfinal, tsam)
}
\arguments{
\item{signal}{A string input containing either values of: \code{square, sin, cos, pulse} in the following format:

                   'sq' or 'square' - Square wave

                   'si' or 'sine'  -  Sine wave

                   'co' or 'cos' -  Cosine wave

                   'pu' or 'pulse' -  Periodic pulse}

\item{tau}{Duration of one period in seconds. Default is 5}

\item{tfinal}{Duration of the signal in seconds. Default is 30}

\item{tsam}{sampling time in seconds. Default is 0.01}
}
\value{
Returns a list of two single column matrices, \code{u} and \code{t}

        \code{u} is the vector of signal values

        \code{t} is the time vector of the signal
}
\description{
\code{gensig} generates a periodic signal. More useful when used in combination with \code{lsim}
}
\details{
\code{gensig} generates a periodic signal of the following types: \code{square, sin, cos, pulse}

Possible usage: \code{gensig(signal)}
}
\examples{

\dontrun{ A square wave signal }
sig <-  gensig('square', 4, 10, 0.1)
plot(sig$t, sig$u, type = "l", col = "blue")
grid(5,5, col = "lightgray")

\dontrun{ A sine wave signal }

sig <-  gensig('sin')
plot(sig$t, sig$u, type = "l", col = "blue")
grid(5,5, col = "lightgray")

}
\seealso{
\code{\link{lsim}}
}
