% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lsimplot.R
\name{lsimplot}
\alias{lsimplot}
\title{Plot time response of an LTI system}
\usage{
lsimplot(sys, u, t, x0)
}
\arguments{
\item{sys}{An LTI system of \code{tf}, \code{ss} and \code{zpk} class}

\item{u}{A row vector for single input systems. The input \code{u} must have as many rows as there are inputs
in the system. Each column of \code{u} corresponds to a new time point. \code{u} could be generated using a signal generator
such as \code{gensig}}

\item{t}{time vector which must be regularly spaced. e.g. \code{seq(0,4,0.1)}}

\item{x0}{a vector of initial conditions with as many rows as the rows of \code{sys$A}}
}
\value{
Returns a plot for the response of the system
}
\description{
\code{lsimplot} Plots the time response of a Linear system described by:
 \deqn{x = Ax + Bu}
 \deqn{ y = Cx + Du}
 to the input time history \code{u}.
}
\details{
\code{lsimplot(sys, u, t)} plots the time history of the linear system with zero-initial conditions.

\code{lsimplot(sys, u, t, x0)} plots the time history of the linear system with given initial conditions.

 If the linear system is represented as a model of \code{tf} or \code{zpk}
 it is first converted to state-space before linear simulation is performed. This function depends on \code{c2d} and \code{ltitr}
}
\examples{
signal <- gensig('square',4,10,0.1)
H <- tf(c(2, 5, 1),c(1, 2, 3))
lsimplot(H, signal$u, signal$t)

\dontrun{ MIMO system response }
A <- rbind(c(0,1), c(-25,-4)); B <- rbind(c(1,1), c(0,1))
C <- rbind(c(1,0), c(0,1)); D <- rbind(c(0,0), c(0,0))
lsimplot(ss(A,B,C,D), cbind(signal$u, signal$u), signal$t)

}
\seealso{
\code{\link{lsim}} \code{\link{stepplot}}   \code{\link{rampplot}}
}
