% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tf.R
\name{tf}
\alias{tf}
\title{Create Transfer function Model.}
\usage{
tf(num, den, Ts = NULL)
}
\arguments{
\item{num}{A numeric vector or matrix (for multivariable systems)}

\item{den}{A numeric vector or matrix (for multivariable systems)}

\item{Ts}{Sample time for discrete time systems}
}
\value{
Returns an object of 'tf' class list with a proper transfer function or with warnings when not proper.
}
\description{
\code{tf} creates the model for a transfer function
}
\details{
\code{tf} creates a model object for a transfer function, Where \code{num} is the numerator and \code{den} is the denominator
of the transfer function.
}
\examples{
tf(1, c(1,2,1))
sys1 <- tf(1, c(1,2,1))
sys1$num
sys1$den

\dontrun{  for single-input multi-output systems (SIMO) each numerator row for one output }
num = rbind(c(0,1,1), c(1,0,1))
den = rbind(c(1,3,2))
tf(num, den)

}
\seealso{
\code{\link{ss}} \code{\link{zpk}} \code{\link{TF}} \code{\link{tf2ss}} \code{\link{tf2zp}}
}
