% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tf2ss.R
\name{tf2ss}
\alias{tf2ss}
\title{Transfer function model conversion to State-space model.}
\usage{
tf2ss(num, den)
}
\arguments{
\item{num}{A numeric vector containing the coefficients of the}

\item{den}{A numeric vector containing the coefficients of the}
}
\value{
Returns an object of 'ss' class.
}
\description{
\code{tf2ss} converts the model for a transfer function to state-space representation
}
\details{
\code{tf2ss} converts a model object for a transfer function to a state-space model, Where \code{num} is the numerator and \code{den} is the denominator
of the transfer function and \code{sys} is a transfer function object

Another possible call is \code{tf2ss(sys)} where \code{sys} is object of transfer-function model.
}
\examples{
tf2ss(tf(1, c(1,2,1)))

\dontrun{  OR }

sys <- tf(1, c(1,2,1))
tf2ss(sys)

\dontrun{  OR }

sys2 <- tf2ss(1, c(1,2,1))

}
\seealso{
\code{\link{ss2tf}} \code{\link{tf2zp}}
}
