% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main_functions_utilities.R
\name{combine_sims}
\alias{combine_sims}
\title{Utility and visualization functions for speech similarity analysis}
\usage{
combine_sims(similarities, weights = NULL)
}
\arguments{
\item{similarities}{A named list of similarity scores}

\item{weights}{A named list of weights for each similarity measure (optional)}
}
\value{
A single combined similarity score
}
\description{
This file contains utility functions and visualization tools to complement
the main similarity calculation functions for comparing two speeches.
Combine multiple similarity measures
}
\details{
This function combines multiple similarity measures into a single score.
}
\examples{
sims <- list(topic = 0.8, lexical = 0.6, semantic = 0.7, structural = 0.9)
combine_sims(sims)
combine_sims(sims, weights = list(topic = 2, lexical = 1, semantic = 1.5, structural = 1))
print(plot)
}
