% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/singlevar.R
\name{cophe.single}
\alias{cophe.single}
\title{Bayesian cophescan analysis using Approximate Bayes Factors}
\usage{
cophe.single(
  dataset,
  querysnpid,
  querytrait,
  MAF = NULL,
  pa = 3.82e-05,
  pc = 0.00182,
  p1 = NULL,
  p2 = NULL,
  p12 = NULL
)
}
\arguments{
\item{dataset}{a list with specifically named elements defining the query trait dataset
to be analysed.}

\item{querysnpid}{Id of the query variant, (id in dataset$snp)}

\item{querytrait}{Query trait name}

\item{MAF}{Minor allele frequency vector}

\item{pa}{prior probability that a non-query variant is causally associated with the query trait (cophescan prior), default 3.82e-5}

\item{pc}{prior probability that the query variant is causally associated with the query trait (cophescan prior), default 1.82e-3 (cophescan prior)}

\item{p1}{prior probability a SNP is associated with trait 1, (coloc prior), pc derived by using \eqn{pc =  p12/p1+p12}; use p1, p2, p12 only when pa and pc are unavailable (See vignettes)}

\item{p2}{prior probability a SNP is associated with trait 2,  (coloc prior), pa derived by using \eqn{pa = p2}}

\item{p12}{prior probability a SNP is associated with both traits,  (coloc prior), pc derived by using \eqn{pc =  p12/p1+p12}}
}
\value{
a list of two \code{data.frame}s:
\itemize{
\item summary is a vector giving the number of SNPs analysed, and the posterior probabilities of Hn (no shared causal variant), Ha (two distinct causal variants) and Hc (one common causal variant)
\item results is an annotated version of the input data containing log Approximate Bayes Factors and intermediate calculations, and the posterior probability SNP.PP.Hc of the SNP being causal for the shared signal \emph{if} Hc is true. This is only relevant if the posterior support for Hc in summary is convincing.
}
}
\description{
Bayesian cophescan analysis under single causal variant assumption
}
\details{
This function calculates posterior probabilities of different
causal variant configurations under the assumption of a single
causal variant for each trait.

If regression coefficients and variances are available, it
calculates Bayes factors for association at each SNP.  If only p
values are available, it uses an approximation that depends on the
SNP's MAF and ignores any uncertainty in imputation.  Regression
coefficients should be used if available. Find more input data structure details
in the coloc package
}
\examples{
library(cophescan)
data(cophe_multi_trait_data)
query_trait_1 <- cophe_multi_trait_data$summ_stat[['Trait_1']]
querysnpid <- cophe_multi_trait_data$querysnpid
res.single <- cophe.single(query_trait_1, querysnpid = querysnpid, querytrait='Trait_1')
summary(res.single)
}
\author{
Ichcha Manipur
}
