% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set_taxonomy.R
\name{set_taxonomy}
\alias{set_taxonomy}
\title{Set, create or modify columns with taxonomic information}
\usage{
set_taxonomy(
  .df,
  kingdom = NULL,
  phylum = NULL,
  class = NULL,
  order = NULL,
  family = NULL,
  genus = NULL,
  specificEpithet = NULL,
  vernacularName = NULL,
  .keep = "unused"
)
}
\arguments{
\item{.df}{A \code{data.frame} or \code{tibble} that the column should be appended to.}

\item{kingdom}{The kingdom name of identified taxon.}

\item{phylum}{The phylum name of identified taxon.}

\item{class}{The class name of identified taxon.}

\item{order}{The order name of identified taxon.}

\item{family}{The family name of identified taxon.}

\item{genus}{The genus name of the identified taxon.}

\item{specificEpithet}{The name of the first species or species epithet of
the \code{scientificName}.
\href{https://dwc.tdwg.org/list/#dwc_specificEpithet}{See documentation}}

\item{vernacularName}{The common or vernacular name of the identified taxon.}

\item{.keep}{Control which columns from .data are retained in the output.
Note that unlike \code{\link[dplyr:mutate]{dplyr::mutate()}}, which defaults to \code{"all"} this defaults to
\code{"unused"}; i.e. only keeps Darwin Core columns, and not those columns used to
generate them.}
}
\value{
A \code{tibble} with the requested columns added/reformatted.
}
\description{
Format fields that contain taxonomic name information from kingdom to
species, as well as the common/vernacular name, to a \code{tibble} using
Darwin Core Standard.

In practice this is no different from using \code{mutate()}, but gives some
informative errors, and serves as a useful lookup for accepted column names in
the Darwin Core Standard.
}
\details{
Examples of \code{specificEphithet}:
\itemize{
\item If \code{scientificName} is \verb{Abies concolor}, the \code{specificEpithet} is \code{concolor}.
\item If \code{scientificName} is \verb{Semisulcospira gottschei}, the \code{specificEpithet} is \code{gottschei}.
}
}
\examples{
df <- tibble::tibble(
  scientificName = c("Crinia Signifera", "Crinia Signifera", "Litoria peronii"),
  fam = c("Myobatrachidae", "Myobatrachidae", "Hylidae"),
  ord = c("Anura", "Anura", "Anura"),
  latitude = c(-35.27, -35.24, -35.83),
  longitude = c(149.33, 149.34, 149.34),
  eventDate = c("2010-10-14", "2010-10-14", "2010-10-14")
  )

# Reformat columns to Darwin Core terms
df |>
  set_scientific_name(
    scientificName = scientificName
    ) |>
  set_taxonomy(
    family = fam,
    order = ord
    )

}
\seealso{
\code{\link[=set_scientific_name]{set_scientific_name()}} for adding \code{scientificName} and authorship information.
}
