# Generated by LaTeX DogWagger Version 4.0.5 from file <NCTLL_904.tex>
# Date: [2020-9-17 13:16:5] 
# Do NOT edit this file. Edit the LaTeX source!!

# - <Section 4> - 
#' Plot Semmelweis' original data from Vienna. 
#' 
#'   First simply 'plots the dots';
#'   subsequently draws a run chart with a transition at the point where 
#'      he instituted hand-washing. 
#' 
#' @param pdf default FALSE will *not* print the two PDF files:
#'    semmelweis_plot.pdf 
#'    semmelweis_run.pdf 
#' @keywords corona Vienna Semmelweis 
#' @import qicharts2 
#' @import ggplot2 
#' @export 
#' @examples
#' corona_vienna ( ) 

corona_vienna <- function ( pdf=FALSE ) 
{ mydeaths <- "Deaths in the First Clinic"; 

  PlotFilename = 'semmelweis_plot.pdf';
  RunFilename = 'semmelweis_run.pdf'; 
  corona_pdf(PlotFilename, 9, 5, pdf); 

  myplot <- ggplot( vienna, aes(x=date, y=.data$deaths)) + 
    geom_point() + 
    geom_line() + 
    labs(title=mydeaths, x='Date', y='Deaths') + 
    scale_x_date(breaks="1 year", date_labels = "%Y") ;
  corona_print(myplot); 
  corona_pdf_off(PlotFilename, pdf, waitline=TRUE); 

  #################
  # full run chart. 
  qv <- qic(x=vienna$date, y=vienna$deaths, chart='run', part=76, 
          title='Deaths in the First Clinic', xlab='Year', ylab='Deaths');  
  corona_pdf(RunFilename, 9, 5, pdf); 
  # plot(qv); 
  corona_print(qv, islegend=FALSE); 
  corona_pdf_off(RunFilename, pdf); 
} 
# -END OF FILE- 
